/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cloudaccess.webdav;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.cryptomator.cloudaccess.webdav.PropfindEntryData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

class PropfindResponseParser {
    private static final Logger LOG = LoggerFactory.getLogger(PropfindResponseParser.class);
    private static final String TAG_RESPONSE = "response";
    private static final String TAG_HREF = "href";
    private static final String TAG_COLLECTION = "collection";
    private static final String TAG_LAST_MODIFIED = "getlastmodified";
    private static final String TAG_CONTENT_LENGTH = "getcontentlength";
    private static final String TAG_PROPSTAT = "propstat";
    private static final String TAG_STATUS = "status";
    private static final String STATUS_OK = "200";
    private final XmlPullParser xmlPullParser;

    PropfindResponseParser() {
        try {
            this.xmlPullParser = XmlPullParserFactory.newInstance().newPullParser();
        }
        catch (XmlPullParserException e) {
            throw new IllegalStateException(e);
        }
    }

    List<PropfindEntryData> parse(InputStream responseBody) throws XmlPullParserException, IOException {
        ArrayList<PropfindEntryData> entryData = new ArrayList<PropfindEntryData>();
        this.xmlPullParser.setInput(responseBody, "UTF-8");
        while (this.skipToStartOf(TAG_RESPONSE)) {
            PropfindEntryData entry = this.parseResponse();
            if (entry == null) continue;
            entryData.add(entry);
        }
        return entryData;
    }

    private boolean skipToStartOf(String tag) throws XmlPullParserException, IOException {
        do {
            this.xmlPullParser.next();
        } while (!this.endOfDocument() && !this.startOf(tag));
        return this.startOf(tag);
    }

    private PropfindEntryData parseResponse() throws XmlPullParserException, IOException {
        PropfindEntryData entry = null;
        String path = null;
        while (this.nextTagUntilEndOf(TAG_RESPONSE)) {
            if (this.tagIs(TAG_PROPSTAT)) {
                entry = this.defaultIfNull(this.parsePropstatWith200Status(), entry);
                continue;
            }
            if (!this.tagIs(TAG_HREF)) continue;
            path = this.textInCurrentTag().trim();
        }
        if (entry == null) {
            LOG.warn("No propstat element with 200 status in response element. Entry ignored.");
            LOG.debug(String.format("No propstat element with 200 status in response element. Entry ignored. Path: %s", path));
            return null;
        }
        if (path == null) {
            LOG.warn("Missing href in response element. Entry ignored.");
            return null;
        }
        entry.setPath(path);
        return entry;
    }

    private PropfindEntryData parsePropstatWith200Status() throws IOException, XmlPullParserException {
        PropfindEntryData result = new PropfindEntryData();
        boolean statusOk = false;
        while (this.nextTagUntilEndOf(TAG_PROPSTAT)) {
            if (this.tagIs(TAG_STATUS)) {
                String text = this.textInCurrentTag().trim();
                String[] statusSegments = text.split(" ");
                String code = statusSegments.length > 0 ? statusSegments[1] : "";
                statusOk = STATUS_OK.equals(code);
                continue;
            }
            if (this.tagIs(TAG_COLLECTION)) {
                result.setFile(false);
                continue;
            }
            if (this.tagIs(TAG_LAST_MODIFIED)) {
                result.setLastModified(this.parseDate(this.textInCurrentTag()));
                continue;
            }
            if (!this.tagIs(TAG_CONTENT_LENGTH)) continue;
            result.setSize(this.parseLong(this.textInCurrentTag()));
        }
        if (statusOk) {
            return result;
        }
        return null;
    }

    private boolean nextTagUntilEndOf(String tag) throws XmlPullParserException, IOException {
        do {
            this.xmlPullParser.next();
        } while (!this.endOfDocument() && !this.startOfATag() && !this.endOf(tag));
        return this.startOfATag();
    }

    private boolean startOf(String tag) throws XmlPullParserException {
        return this.startOfATag() && this.tagIs(tag);
    }

    private boolean tagIs(String tag) {
        return tag.equalsIgnoreCase(this.localName());
    }

    private boolean startOfATag() throws XmlPullParserException {
        return this.xmlPullParser.getEventType() == 2;
    }

    private boolean endOf(String tag) throws XmlPullParserException {
        return this.xmlPullParser.getEventType() == 3 && tag.equalsIgnoreCase(this.localName());
    }

    private String localName() {
        String rawName = this.xmlPullParser.getName();
        String[] namespaceAndLocalName = rawName.split(":", 2);
        return namespaceAndLocalName[namespaceAndLocalName.length - 1];
    }

    private boolean endOfDocument() throws XmlPullParserException {
        return this.xmlPullParser.getEventType() == 1;
    }

    private String textInCurrentTag() throws IOException, XmlPullParserException {
        if (!this.startOfATag()) {
            throw new IllegalStateException("textInCurrentTag may only be called at start of a tag");
        }
        StringBuilder result = new StringBuilder();
        int ident = 0;
        do {
            switch (this.xmlPullParser.next()) {
                case 4: {
                    result.append(this.xmlPullParser.getText());
                    break;
                }
                case 2: {
                    ++ident;
                    break;
                }
                case 3: {
                    --ident;
                }
            }
        } while (!this.endOfDocument() && ident >= 0);
        return result.toString();
    }

    private PropfindEntryData defaultIfNull(PropfindEntryData value, PropfindEntryData defaultValue) {
        return value == null ? defaultValue : value;
    }

    private Optional<Instant> parseDate(String text) {
        try {
            String RFC_1123_DATE_TIME = "EEE, dd MMM yyyy HH:mm:ss z";
            return Optional.of(new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US).parse(text).toInstant());
        }
        catch (IllegalArgumentException | ParseException e) {
            return Optional.empty();
        }
    }

    private Optional<Long> parseLong(String text) {
        try {
            return Optional.of(Long.parseLong(text));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }
}

