/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cloudaccess.webdav;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cryptomator.cloudaccess.api.CloudItemMetadata;
import org.cryptomator.cloudaccess.api.CloudItemType;

class PropfindEntryData {
    private static final Pattern URI_PATTERN = Pattern.compile("^[a-z]+://[^/]+/(.*)$");
    private Path path;
    private String[] pathSegments;
    private boolean file = true;
    private Optional<Instant> lastModified = Optional.empty();
    private Optional<Long> size = Optional.empty();

    PropfindEntryData() {
    }

    public void setPath(String pathOrUri) {
        this.path = Path.of(this.extractPath(pathOrUri), new String[0]);
        this.pathSegments = this.path.toString().split("/");
    }

    private String extractPath(String pathOrUri) {
        Matcher matcher = URI_PATTERN.matcher(pathOrUri);
        if (matcher.matches()) {
            return this.urlDecode(matcher.group(1));
        }
        if (!pathOrUri.startsWith("/")) {
            return this.urlDecode("/" + pathOrUri);
        }
        return this.urlDecode(pathOrUri);
    }

    void setLastModified(Optional<Instant> lastModified) {
        this.lastModified = lastModified;
    }

    public void setSize(Optional<Long> size) {
        this.size = size;
    }

    public void setFile(boolean file) {
        this.file = file;
    }

    public Path getPath() {
        return this.path;
    }

    public Optional<Long> getSize() {
        return this.size;
    }

    private boolean isFile() {
        return this.file;
    }

    public CloudItemMetadata toCloudItem() {
        if (this.isFile()) {
            return new CloudItemMetadata(this.getName(), this.path, CloudItemType.FILE, this.lastModified, this.size);
        }
        return new CloudItemMetadata(this.getName(), this.path, CloudItemType.FOLDER);
    }

    private String urlDecode(String value) {
        return URLDecoder.decode(value, StandardCharsets.UTF_8);
    }

    int getDepth() {
        return this.pathSegments.length;
    }

    private String getName() {
        return this.pathSegments[this.pathSegments.length - 1];
    }
}

