/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cloudaccess.webdav;

import java.io.IOException;
import java.io.InputStream;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;

public class InputStreamRequestBody
extends RequestBody {
    private final InputStream inputStream;

    public static RequestBody from(InputStream inputStream) {
        return new InputStreamRequestBody(inputStream);
    }

    private InputStreamRequestBody(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("inputStream == null");
        }
        this.inputStream = inputStream;
    }

    public MediaType contentType() {
        return MediaType.parse((String)"application/octet-stream");
    }

    public long contentLength() throws IOException {
        return this.inputStream.available() == 0 ? -1L : (long)this.inputStream.available();
    }

    public void writeTo(BufferedSink sink) throws IOException {
        try (Source source = Okio.source((InputStream)this.inputStream);){
            sink.writeAll(source);
        }
    }
}

