/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cloudaccess.api;

import java.io.InputStream;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.cryptomator.cloudaccess.api.CloudItemList;
import org.cryptomator.cloudaccess.api.CloudItemMetadata;
import org.cryptomator.cloudaccess.api.ProgressListener;

public interface CloudProvider {
    public CompletionStage<CloudItemMetadata> itemMetadata(Path var1);

    public CompletionStage<CloudItemList> list(Path var1, Optional<String> var2);

    default public CompletionStage<CloudItemList> listExhaustively(Path folder) {
        return CloudProvider.listExhaustively(this, folder, CloudItemList.empty());
    }

    private static CompletionStage<CloudItemList> listExhaustively(CloudProvider provider, Path folder, CloudItemList itemList) {
        return provider.list(folder, itemList.getNextPageToken()).thenCompose(nextItems -> {
            CloudItemList combined = itemList.add(nextItems.getItems(), nextItems.getNextPageToken());
            if (nextItems.getNextPageToken().isPresent()) {
                return CloudProvider.listExhaustively(provider, folder, combined);
            }
            return CompletableFuture.completedStage(combined);
        });
    }

    default public CompletionStage<InputStream> read(Path file, ProgressListener progressListener) {
        return this.read(file, 0L, Long.MAX_VALUE, progressListener);
    }

    public CompletionStage<InputStream> read(Path var1, long var2, long var4, ProgressListener var6);

    public CompletionStage<CloudItemMetadata> write(Path var1, boolean var2, InputStream var3, ProgressListener var4);

    public CompletionStage<Path> createFolder(Path var1);

    public CompletionStage<Void> delete(Path var1);

    public CompletionStage<Path> move(Path var1, Path var2, boolean var3);
}

