package org.criticalsection.maven.release.scm;
/*
 * Copyright (C) 2008 Tim Kettler
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import org.apache.maven.shared.release.scm.ScmTranslator;
import org.codehaus.plexus.util.StringUtils;

import java.util.regex.Pattern;
import java.util.regex.Matcher;

/**
 * Monotone tag/branch translator.
 *
 * @plexus.component
 *   role="org.apache.maven.shared.release.scm.ScmTranslator"
 *   role-hint="monotone"
 */
public class MonotoneScmTranslator
    implements ScmTranslator
{
    public String translateBranchUrl( String url, String branchName, String branchBase )
    {
        // Due to the limited interface for not subversion-like vc-systems, assume that a http[s]://
        // URL denotes the web view URL and just skip it.
        if ( url.startsWith( "http" ) )
        {
            return url;
        }

        return "scm:monotone:local://branch/" + branchName;
    }

    public String translateTagUrl( String url, String tag, String tagBase )
    {
        // Due to the limited interface for not subversion-like vc-systems, assume that a http[s]://
        // URL denotes the web view URL and just skip it.
        if ( url.startsWith( "http" ) )
        {
            return url;
        }

        return "scm:monotone:local://tag/" + tag;
    }

    public String resolveTag( String tag )
    {
        return null;
    }
}
