/*
 * Decompiled with CFR 0.152.
 */
package org.criticalsection.maven.scm.provider.monotone.command.status;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.status.AbstractStatusCommand;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.codehaus.plexus.util.StringUtils;
import org.criticalsection.maven.scm.provider.monotone.repository.MonotoneScmProviderRepository;
import org.criticalsection.mtn4java.commands.Command;
import org.criticalsection.mtn4java.commands.automate.InventoryCommand;
import org.criticalsection.mtn4java.commands.automate.InventoryInformation;
import org.criticalsection.mtn4java.commands.invokers.InvokationException;
import org.criticalsection.mtn4java.commands.invokers.StandaloneInvoker;

public class MonotoneStatusCommand
extends AbstractStatusCommand {
    public StatusScmResult executeStatusCommand(ScmProviderRepository repository, ScmFileSet fileSet) throws ScmException {
        Command cmd;
        block5: {
            this.getLogger().debug("Executing status command");
            cmd = this.createCommand(repository);
            try {
                StandaloneInvoker invoker = new StandaloneInvoker("mtn", fileSet.getBasedir().getAbsolutePath());
                invoker.invoke(cmd);
            }
            catch (InvokationException e) {
                if (e.getType() == InvokationException.Type.PRECONDITION_ERROR) {
                    return new StatusScmResult("No commandline cvailable", "Precondition error during command execution.", e.getFormatedErrorMessage(), false);
                }
                if (e.getType() == InvokationException.Type.PROCESS_CREATION_ERROR) {
                    return new StatusScmResult(e.getCommandline(), "Error while crreating the external process during command execution.", e.getFormatedErrorMessage(), false);
                }
                if (e.getType() != InvokationException.Type.EXECUTION_ERROR) break block5;
                return new StatusScmResult(e.getCommandline(), "Error during command execution.", e.getFormatedErrorMessage(), false);
            }
        }
        ArrayList<ScmFile> repositoryStatus = new ArrayList<ScmFile>();
        Map result = (Map)cmd.getResult();
        Iterator i = result.keySet().iterator();
        while (i.hasNext()) {
            ScmFile file;
            String curKey = (String)i.next();
            InventoryInformation curInfo = (InventoryInformation)result.get(curKey);
            if (!this.isFile(curInfo) || (file = this.addFile(curInfo)) == null) continue;
            repositoryStatus.add(file);
        }
        return new StatusScmResult(repositoryStatus, new ScmResult(null, null, null, true));
    }

    Command createCommand(ScmProviderRepository repository) throws ScmRepositoryException {
        MonotoneScmProviderRepository repo = (MonotoneScmProviderRepository)repository;
        InventoryCommand cmd = new InventoryCommand();
        if (repo.getConfigDirectory() != null && StringUtils.isNotEmpty((String)repo.getConfigDirectory())) {
            cmd.setConfigDirPath(repo.getConfigDirectory());
        }
        if (repo.getKeyringDirectory() != null && StringUtils.isNotEmpty((String)repo.getKeyringDirectory())) {
            cmd.setKeyDirPath(repo.getKeyringDirectory());
        }
        if (repo.getKey() != null && StringUtils.isNotEmpty((String)repo.getKey())) {
            cmd.setKey(repo.getKey());
        }
        return cmd;
    }

    private boolean isFile(InventoryInformation info) {
        return info.getNewType() == InventoryInformation.Type.FILE || info.getFilesystemType() == InventoryInformation.FsType.FILE;
    }

    private ScmFile addFile(InventoryInformation info) {
        ScmFile result = null;
        if (info.getStatus().contains(InventoryInformation.Status.ADDED)) {
            result = new ScmFile(info.getPath(), ScmFileStatus.ADDED);
        } else if (info.getStatus().contains(InventoryInformation.Status.DROPPED)) {
            result = new ScmFile(info.getPath(), ScmFileStatus.DELETED);
        } else if (info.getStatus().contains(InventoryInformation.Status.RENAME_SOURCE) || info.getStatus().contains(InventoryInformation.Status.RENAME_TARGET) || info.getChanges().contains(InventoryInformation.ChangeType.CONTENT) || info.getChanges().contains(InventoryInformation.ChangeType.ATTRIBUTES)) {
            result = new ScmFile(info.getPath(), ScmFileStatus.MODIFIED);
        }
        return result;
    }
}

