/*
 * Decompiled with CFR 0.152.
 */
package org.criticalsection.maven.scm.provider.monotone.command.checkout;

import java.io.File;
import java.io.IOException;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkout.AbstractCheckOutCommand;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.criticalsection.maven.scm.provider.monotone.MonotoneCommandlineUtils;
import org.criticalsection.maven.scm.provider.monotone.repository.MonotoneScmProviderRepository;
import org.criticalsection.mtn4java.commands.Command;
import org.criticalsection.mtn4java.commands.invokers.InvokationException;
import org.criticalsection.mtn4java.commands.invokers.StandaloneInvoker;
import org.criticalsection.mtn4java.commands.standalone.CheckoutCommand;

public class MonotoneCheckOutCommand
extends AbstractCheckOutCommand {
    protected CheckOutScmResult executeCheckOutCommand(ScmProviderRepository repository, ScmFileSet fileSet, ScmVersion version) throws ScmException {
        File checkoutDir;
        block7: {
            this.getLogger().debug("Executing checkout command");
            checkoutDir = fileSet.getBasedir();
            if (checkoutDir.exists()) {
                try {
                    FileUtils.deleteDirectory((File)checkoutDir);
                }
                catch (IOException e) {
                    throw new ScmException("The checkout dir already exists and I can't delete it.", (Throwable)e);
                }
            }
            Command cmd = this.createCommand(repository, checkoutDir, version);
            try {
                StandaloneInvoker invoker = new StandaloneInvoker("mtn", fileSet.getBasedir().getParentFile().getAbsolutePath());
                invoker.invoke(cmd);
            }
            catch (InvokationException e) {
                if (e.getType() == InvokationException.Type.PRECONDITION_ERROR) {
                    return new CheckOutScmResult("No commandline cvailable", "Precondition error during command execution.", e.getFormatedErrorMessage(), false);
                }
                if (e.getType() == InvokationException.Type.PROCESS_CREATION_ERROR) {
                    return new CheckOutScmResult(e.getCommandline(), "Error while crreating the external process during command execution.", e.getFormatedErrorMessage(), false);
                }
                if (e.getType() != InvokationException.Type.EXECUTION_ERROR) break block7;
                return new CheckOutScmResult(e.getCommandline(), "Error during command execution.", e.getFormatedErrorMessage(), false);
            }
        }
        return new CheckOutScmResult(MonotoneCommandlineUtils.getWorkingCopyFiles(checkoutDir), new ScmResult(null, null, null, true));
    }

    Command createCommand(ScmProviderRepository repository, File checkoutDirectory, ScmVersion version) throws ScmRepositoryException {
        MonotoneScmProviderRepository repo = (MonotoneScmProviderRepository)repository;
        CheckoutCommand cmd = new CheckoutCommand();
        if (repo.getConfigDirectory() != null && StringUtils.isNotEmpty((String)repo.getConfigDirectory())) {
            cmd.setConfigDirPath(repo.getConfigDirectory());
        }
        if (repo.getKeyringDirectory() != null && StringUtils.isNotEmpty((String)repo.getKeyringDirectory())) {
            cmd.setKeyDirPath(repo.getKeyringDirectory());
        }
        if (repo.getKey() != null && StringUtils.isNotEmpty((String)repo.getKey())) {
            cmd.setKey(repo.getKey());
        }
        cmd.setDatabasePath(repo.getDatabase());
        if (version != null && version.getType().equals("Branch")) {
            cmd.setBranch(version.getName());
        } else if (version != null && version.getType().equals("Revision")) {
            cmd.setRevision("i:" + version.getName());
        } else if (version != null && version.getType().equals("Tag")) {
            cmd.setRevision("t:" + version.getName());
        } else if (repo.getBranch() != null) {
            cmd.setBranch(repo.getBranch());
        } else if (repo.getTag() != null) {
            cmd.setRevision("t:" + repo.getTag());
        } else {
            throw new ScmRepositoryException("No revision to check out from specified.");
        }
        cmd.setWorkspacePath(checkoutDirectory.getAbsolutePath());
        return cmd;
    }
}

