/*
 * Decompiled with CFR 0.152.
 */
package org.criticalsection.maven.scm.provider.monotone.command.checkin;

import java.io.File;
import java.io.IOException;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkin.AbstractCheckInCommand;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.criticalsection.maven.scm.provider.monotone.command.status.MonotoneStatusCommand;
import org.criticalsection.maven.scm.provider.monotone.repository.MonotoneScmProviderRepository;
import org.criticalsection.mtn4java.commands.Command;
import org.criticalsection.mtn4java.commands.invokers.InvokationException;
import org.criticalsection.mtn4java.commands.invokers.StandaloneInvoker;
import org.criticalsection.mtn4java.commands.standalone.CommitCommand;

public class MonotoneCheckInCommand
extends AbstractCheckInCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CheckInScmResult executeCheckInCommand(ScmProviderRepository repository, ScmFileSet fileSet, String message, ScmVersion scmVersion) throws ScmException {
        this.getLogger().debug("Executing checkin command");
        if (scmVersion != null) {
            throw new ScmException("This provider can't handle tags.");
        }
        if (fileSet.getFileList().size() != 0) {
            this.getLogger().warn("This provider doesn't support committing individual files. Commiting whole workspace.");
        }
        MonotoneStatusCommand statusCmd = new MonotoneStatusCommand();
        statusCmd.setLogger(this.getLogger());
        StatusScmResult statusResult = statusCmd.executeStatusCommand(repository, fileSet);
        if (!statusResult.isSuccess()) {
            return new CheckInScmResult(statusResult.getCommandLine(), "Error obtaining the status of the working copy.", statusResult.getCommandOutput(), false);
        }
        File messageFile = FileUtils.createTempFile((String)"maven-scm-", (String)".commit", null);
        try {
            FileUtils.fileWrite((String)messageFile.getAbsolutePath(), (String)message);
        }
        catch (IOException ex) {
            return new CheckInScmResult(null, "Error while making a temporary file for the commit message: " + ex.getMessage(), null, false);
        }
        Command cmd = this.createCommand(repository, messageFile.getAbsolutePath());
        try {
            StandaloneInvoker invoker = new StandaloneInvoker("mtn", fileSet.getBasedir().getAbsolutePath());
            invoker.invoke(cmd);
        }
        catch (InvokationException e) {
            if (e.getType() == InvokationException.Type.PRECONDITION_ERROR) {
                CheckInScmResult checkInScmResult = new CheckInScmResult("No commandline cvailable", "Precondition error during command execution.", e.getFormatedErrorMessage(), false);
                return checkInScmResult;
            }
            if (e.getType() == InvokationException.Type.PROCESS_CREATION_ERROR) {
                CheckInScmResult checkInScmResult = new CheckInScmResult(e.getCommandline(), "Error while crreating the external process during command execution.", e.getFormatedErrorMessage(), false);
                return checkInScmResult;
            }
            if (e.getType() == InvokationException.Type.EXECUTION_ERROR) {
                CheckInScmResult checkInScmResult = new CheckInScmResult(e.getCommandline(), "Error during command execution.", e.getFormatedErrorMessage(), false);
                return checkInScmResult;
            }
        }
        finally {
            try {
                FileUtils.forceDelete((File)messageFile);
            }
            catch (IOException ex) {}
        }
        return new CheckInScmResult(statusResult.getChangedFiles(), new ScmResult(null, null, null, true));
    }

    Command createCommand(ScmProviderRepository repository, String message) throws ScmRepositoryException {
        MonotoneScmProviderRepository repo = (MonotoneScmProviderRepository)repository;
        CommitCommand cmd = new CommitCommand();
        if (repo.getConfigDirectory() != null && StringUtils.isNotEmpty((String)repo.getConfigDirectory())) {
            cmd.setConfigDirPath(repo.getConfigDirectory());
        }
        if (repo.getKeyringDirectory() != null && StringUtils.isNotEmpty((String)repo.getKeyringDirectory())) {
            cmd.setKeyDirPath(repo.getKeyringDirectory());
        }
        if (repo.getKey() != null && StringUtils.isNotEmpty((String)repo.getKey())) {
            cmd.setKey(repo.getKey());
        }
        cmd.setMessageFilePath(message);
        return cmd;
    }
}

