/*
 * Decompiled with CFR 0.152.
 */
package org.criticalsection.maven.scm.provider.monotone.command.baserevision;

import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.AbstractCommand;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.codehaus.plexus.util.StringUtils;
import org.criticalsection.maven.scm.provider.monotone.command.baserevision.BaseRevisionScmResult;
import org.criticalsection.maven.scm.provider.monotone.repository.MonotoneScmProviderRepository;
import org.criticalsection.mtn4java.commands.Command;
import org.criticalsection.mtn4java.commands.automate.BaseRevisionIdCommand;
import org.criticalsection.mtn4java.commands.invokers.InvokationException;
import org.criticalsection.mtn4java.commands.invokers.StandaloneInvoker;

public class MonotoneBaseRevisionCommand
extends AbstractCommand {
    public ScmResult executeCommand(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return this.executeBaseRevisionCommand(repository, fileSet);
    }

    public BaseRevisionScmResult executeBaseRevisionCommand(ScmProviderRepository repository, ScmFileSet fileSet) throws ScmException {
        Command cmd;
        block4: {
            this.getLogger().debug("Executing 'automate get_base_revision' command");
            cmd = this.createCommand(repository);
            try {
                StandaloneInvoker invoker = new StandaloneInvoker("mtn", fileSet.getBasedir().getAbsolutePath());
                invoker.invoke(cmd);
            }
            catch (InvokationException e) {
                if (e.getType() == InvokationException.Type.PRECONDITION_ERROR) {
                    return new BaseRevisionScmResult("No commandline cvailable", "Precondition error during command execution.", e.getFormatedErrorMessage(), false);
                }
                if (e.getType() == InvokationException.Type.PROCESS_CREATION_ERROR) {
                    return new BaseRevisionScmResult(e.getCommandline(), "Error while crreating the external process during command execution.", e.getFormatedErrorMessage(), false);
                }
                if (e.getType() != InvokationException.Type.EXECUTION_ERROR) break block4;
                return new BaseRevisionScmResult(e.getCommandline(), "Error during command execution.", e.getFormatedErrorMessage(), false);
            }
        }
        return new BaseRevisionScmResult(new ScmResult(null, null, null, true), (String)cmd.getResult());
    }

    Command createCommand(ScmProviderRepository repository) throws ScmRepositoryException {
        MonotoneScmProviderRepository repo = (MonotoneScmProviderRepository)repository;
        BaseRevisionIdCommand cmd = new BaseRevisionIdCommand();
        if (repo.getConfigDirectory() != null && StringUtils.isNotEmpty((String)repo.getConfigDirectory())) {
            cmd.setConfigDirPath(repo.getConfigDirectory());
        }
        if (repo.getKeyringDirectory() != null && StringUtils.isNotEmpty((String)repo.getKeyringDirectory())) {
            cmd.setKeyDirPath(repo.getKeyringDirectory());
        }
        if (repo.getKey() != null && StringUtils.isNotEmpty((String)repo.getKey())) {
            cmd.setKey(repo.getKey());
        }
        return cmd;
    }
}

