/*
 * Decompiled with CFR 0.152.
 */
package org.criticalsection.maven.scm.provider.monotone;

import java.io.File;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.command.branch.BranchScmResult;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.provider.AbstractScmProvider;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.scm.repository.UnknownRepositoryStructure;
import org.criticalsection.maven.scm.provider.monotone.MonotoneSettingsProvider;
import org.criticalsection.maven.scm.provider.monotone.command.add.MonotoneAddCommand;
import org.criticalsection.maven.scm.provider.monotone.command.branch.MonotoneBranchCommand;
import org.criticalsection.maven.scm.provider.monotone.command.checkin.MonotoneCheckInCommand;
import org.criticalsection.maven.scm.provider.monotone.command.checkout.MonotoneCheckOutCommand;
import org.criticalsection.maven.scm.provider.monotone.command.status.MonotoneStatusCommand;
import org.criticalsection.maven.scm.provider.monotone.command.tag.MonotoneTagCommand;
import org.criticalsection.maven.scm.provider.monotone.repository.MonotoneScmProviderRepository;

public class MonotoneScmProvider
extends AbstractScmProvider {
    private MonotoneSettingsProvider settingsProvider;

    public String getScmSpecificFilename() {
        this.getLogger().info("getScmSpecificFilename()");
        return "_MTN";
    }

    public String getScmType() {
        this.getLogger().info("getScmType()");
        return "monotone";
    }

    public ScmProviderRepository makeProviderScmRepository(String scmSpecificUrl, char delimiter) throws ScmRepositoryException {
        return new MonotoneScmProviderRepository(scmSpecificUrl, this.settingsProvider);
    }

    public ScmProviderRepository makeProviderScmRepository(File path) throws ScmRepositoryException, UnknownRepositoryStructure {
        if (path == null || !path.isDirectory()) {
            throw new NullPointerException("Path argument is null");
        }
        if (!path.isDirectory()) {
            throw new ScmRepositoryException(path.getAbsolutePath() + " isn't a valid directory.");
        }
        if (!new File(path, this.getScmSpecificFilename()).exists()) {
            throw new ScmRepositoryException(path.getAbsolutePath() + " isn't a monotone workspace directory.");
        }
        try {
            return this.makeProviderScmRepository(this.getRepositoryURL(path), '|');
        }
        catch (ScmException e) {
            throw new ScmRepositoryException("Error executing info command", (Throwable)e);
        }
    }

    protected String getRepositoryURL(File path) throws ScmException {
        return null;
    }

    public CheckOutScmResult checkout(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        MonotoneCheckOutCommand command = new MonotoneCheckOutCommand();
        command.setLogger(this.getLogger());
        return (CheckOutScmResult)command.execute(repository, fileSet, parameters);
    }

    public AddScmResult add(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        MonotoneAddCommand command = new MonotoneAddCommand();
        command.setLogger(this.getLogger());
        return (AddScmResult)command.execute(repository, fileSet, parameters);
    }

    public StatusScmResult status(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        MonotoneStatusCommand command = new MonotoneStatusCommand();
        command.setLogger(this.getLogger());
        return (StatusScmResult)command.execute(repository, fileSet, parameters);
    }

    public CheckInScmResult checkin(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        MonotoneCheckInCommand command = new MonotoneCheckInCommand();
        command.setLogger(this.getLogger());
        return (CheckInScmResult)command.execute(repository, fileSet, parameters);
    }

    public TagScmResult tag(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        MonotoneTagCommand command = new MonotoneTagCommand();
        command.setLogger(this.getLogger());
        return (TagScmResult)command.execute(repository, fileSet, parameters);
    }

    protected BranchScmResult branch(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        MonotoneBranchCommand command = new MonotoneBranchCommand();
        command.setLogger(this.getLogger());
        return (BranchScmResult)command.execute(repository, fileSet, parameters);
    }
}

