/*
 * Decompiled with CFR 0.152.
 */
package org.criticalsection.maven.scm.provider.monotone;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.codehaus.plexus.util.FileUtils;

public class MonotoneCommandlineUtils {
    private static final String LUA_HOOK = "do\n  local old_hook = get_passphrase\n\n  function get_passphrase(keypair_id)\n    if old_hook == nil then\n      return \"\"\n    else\n      return old_hook(keypair_id)\n    end\n  end\nend";

    public static List getWorkingCopyFiles(File directory) throws ScmException {
        List files;
        ArrayList<ScmFile> fileList = new ArrayList<ScmFile>();
        try {
            files = FileUtils.getFiles((File)directory, (String)"**", (String)"**/_MTN/**", (boolean)false);
        }
        catch (IOException e) {
            throw new ScmException("Error while executing command.", (Throwable)e);
        }
        Iterator i = files.iterator();
        while (i.hasNext()) {
            File f = (File)i.next();
            fileList.add(new ScmFile(f.getPath(), ScmFileStatus.TAGGED));
        }
        return fileList;
    }

    public static String searchWorkspaceRoot(String startPath) {
        File curDir = new File(startPath);
        File[] files = curDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.equals("_MTN");
            }
        });
        if (files.length == 1) {
            return curDir.getAbsolutePath();
        }
        if (curDir.getParentFile() != null) {
            return MonotoneCommandlineUtils.searchWorkspaceRoot(curDir.getParentFile().getAbsolutePath());
        }
        return null;
    }
}

