/*
 * Decompiled with CFR 0.152.
 */
package org.criticalsection.maven.scm.provider.monotone;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.criticalsection.maven.scm.provider.monotone.MonotoneCommandlineUtils;
import org.criticalsection.maven.scm.provider.monotone.MonotoneSettingsProvider;
import org.criticalsection.maven.scm.providers.monotone.settings.Settings;
import org.criticalsection.maven.scm.providers.monotone.settings.io.xpp3.MtnXpp3Reader;

public class DefaultMonotoneSettingsProvider
implements MonotoneSettingsProvider {
    private static final Pattern DATABASE_ENTRY = Pattern.compile("^.*database \"(.*)\"$");
    private static final Pattern KEY_ENTRY = Pattern.compile("^.*key \"(.*)\"$");
    private static final Pattern KEYDIR_ENTRY = Pattern.compile("^.*keydir \"(.*)\"$");
    private Settings settings = this.getSettings();
    private String workspaceDatabase;
    private String workspaceKeydir;
    private String workspaceKey;
    private String configDirectory;
    private String keyringDirectory;
    private String database;
    private String key;

    public DefaultMonotoneSettingsProvider() {
        this.getWorkspaceOptions();
    }

    public String getConfigDirectory() {
        if (this.configDirectory == null && System.getProperty("maven.scm.monotone.configDir") != null) {
            this.configDirectory = System.getProperty("maven.scm.monotone.configDir");
        }
        if (this.configDirectory == null && this.settings != null && this.settings.getConfigDirectory() != null) {
            this.configDirectory = this.settings.getConfigDirectory();
        }
        return this.configDirectory;
    }

    public String getKeyringDirectory() {
        if (this.keyringDirectory == null && System.getProperty("maven.scm.monotone.keyringDir") != null) {
            this.keyringDirectory = System.getProperty("maven.scm.monotone.keyringDir");
        }
        if (this.keyringDirectory == null && this.settings != null && this.settings.getKeyringDirectory() != null) {
            this.keyringDirectory = this.settings.getConfigDirectory();
        }
        if (this.keyringDirectory == null && this.workspaceKeydir != null) {
            this.keyringDirectory = this.workspaceKeydir;
        }
        return this.keyringDirectory;
    }

    public String getDatabase() throws ScmRepositoryException {
        if (this.database == null && System.getProperty("maven.scm.monotone.database") != null) {
            this.database = System.getProperty("maven.scm.monotone.database");
        }
        if (this.database == null && this.settings != null && this.settings.getDatabase() != null) {
            this.database = this.settings.getDatabase();
        }
        if (this.database == null && this.workspaceDatabase != null) {
            this.database = this.workspaceDatabase;
        }
        return this.database;
    }

    public String getKey() throws ScmRepositoryException {
        if (this.key == null && System.getProperty("maven.scm.monotone.key") != null) {
            this.key = System.getProperty("maven.scm.monotone.key");
        }
        if (this.key == null && this.settings != null && this.settings.getKey() != null) {
            this.key = this.settings.getKey();
        }
        if (this.key == null && this.workspaceKey != null) {
            this.key = this.workspaceKey;
        }
        if (this.key == null) {
            throw new ScmRepositoryException("No key specified.");
        }
        return this.key;
    }

    private Settings getSettings() {
        File scmUserDir = new File(System.getProperty("user.home"), ".scm");
        File settingsFile = new File(scmUserDir, "mtn-settings.xml");
        if (settingsFile.exists()) {
            MtnXpp3Reader reader = new MtnXpp3Reader();
            try {
                return reader.read(new FileReader(settingsFile));
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
            }
            catch (XmlPullParserException e) {
                StringBuffer message = new StringBuffer();
                message.append(settingsFile.getAbsolutePath());
                message.append(" isn't well formed. SKIPPED:\n  ");
                message.append(e.getMessage());
                System.out.println(message.toString());
            }
        }
        return new Settings();
    }

    private void getWorkspaceOptions() {
        String workspaceRoot = MonotoneCommandlineUtils.searchWorkspaceRoot(".");
        if (workspaceRoot != null) {
            BufferedReader reader;
            File options = new File(workspaceRoot + File.separator + "_MTN" + File.separator + "options");
            try {
                reader = new BufferedReader(new InputStreamReader(new FileInputStream(options)));
            }
            catch (FileNotFoundException e) {
                return;
            }
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    Matcher m;
                    if (DATABASE_ENTRY.matcher(line).matches()) {
                        m = DATABASE_ENTRY.matcher(line);
                        m.matches();
                        this.workspaceDatabase = m.group(1);
                    }
                    if (KEY_ENTRY.matcher(line).matches()) {
                        m = KEY_ENTRY.matcher(line);
                        m.matches();
                        this.workspaceKey = m.group(1);
                    }
                    if (!KEYDIR_ENTRY.matcher(line).matches()) continue;
                    m = KEYDIR_ENTRY.matcher(line);
                    m.matches();
                    this.workspaceKeydir = m.group(1);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                reader.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }
}

