/*
 * $Id$
 */

package org.criticalsection.maven.scm.providers.monotone.settings;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * null
 * 
 * @version $Revision$ $Date$
 */
public class Settings implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field configDirectory
     */
    private String configDirectory;

    /**
     * Field keyringDirectory
     */
    private String keyringDirectory;

    /**
     * Field database
     */
    private String database;

    /**
     * Field key
     */
    private String key;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *              Instructs Monotone to read configuration
     * information from the specified directory instead of the
     * default location.
     *           
     */
    public String getConfigDirectory()
    {
        return this.configDirectory;
    } //-- String getConfigDirectory() 

    /**
     * Get 
     *              Instructs Monotone to use the specified
     * database for operations.
     *           
     */
    public String getDatabase()
    {
        return this.database;
    } //-- String getDatabase() 

    /**
     * Get 
     *              Instructs Monotone to use the specified key for
     * commit operations.
     *           
     */
    public String getKey()
    {
        return this.key;
    } //-- String getKey() 

    /**
     * Get 
     *              Instructs Monotone to read the keys from the
     * specified directory instead of the default location.
     *           
     */
    public String getKeyringDirectory()
    {
        return this.keyringDirectory;
    } //-- String getKeyringDirectory() 

    /**
     * Set 
     *              Instructs Monotone to read configuration
     * information from the specified directory instead of the
     * default location.
     *           
     * 
     * @param configDirectory
     */
    public void setConfigDirectory(String configDirectory)
    {
        this.configDirectory = configDirectory;
    } //-- void setConfigDirectory(String) 

    /**
     * Set 
     *              Instructs Monotone to use the specified
     * database for operations.
     *           
     * 
     * @param database
     */
    public void setDatabase(String database)
    {
        this.database = database;
    } //-- void setDatabase(String) 

    /**
     * Set 
     *              Instructs Monotone to use the specified key for
     * commit operations.
     *           
     * 
     * @param key
     */
    public void setKey(String key)
    {
        this.key = key;
    } //-- void setKey(String) 

    /**
     * Set 
     *              Instructs Monotone to read the keys from the
     * specified directory instead of the default location.
     *           
     * 
     * @param keyringDirectory
     */
    public void setKeyringDirectory(String keyringDirectory)
    {
        this.keyringDirectory = keyringDirectory;
    } //-- void setKeyringDirectory(String) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
