package org.criticalsection.maven.scm.provider.monotone.command.baserevision;
/*
 * Copyright (C) 2008 Tim Kettler
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import org.apache.maven.scm.ScmResult;

public class BaseRevisionScmResult extends ScmResult
{
    private String baseRevision;

    public BaseRevisionScmResult( String commandLine, String providerMessage, String commandOutput, boolean success )
    {
        super( commandLine, providerMessage, commandOutput, success );
    }

    public BaseRevisionScmResult( ScmResult scmResult, String baseRevision )
    {
        super( scmResult );
        this.baseRevision = baseRevision;
    }

    public BaseRevisionScmResult( String commandLine, String baseRevision )
    {
        super( commandLine, null, null, true );
        this.baseRevision = baseRevision;
    }

    public String getBaseRevision()
    {
        return baseRevision;
    }
}
