package org.criticalsection.maven.scm.provider.monotone;
/*
 * Copyright (C) 2008 Tim Kettler
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import org.apache.maven.scm.repository.ScmRepositoryException;

/**
 * Provides runtime access to the configuration options of this scm provider.
 * <p>
 * The monotone scm provider allows the configuration of some core runtime options. First, it allows the
 * configuration of the config and keyring directories monotone uses during runtime. Then, it allows to
 * specifiy the database to use when performing operations like checkout. And last, one can configure the
 * key to use when doing database manipulating operations.
 *
 * @author Tim Kettler <tik@criticalsection.org> 
 */
public interface MonotoneSettingsProvider
{
    String ROLE = MonotoneSettingsProvider.class.getName();

    static final String CONFIG_DIR_PROPERTY = "maven.scm.monotone.configDir";

    static final String KEYRING_DIR_PROPERTY = "maven.scm.monotone.keyringDir";

    static final String DATABASE_PROPERTY = "maven.scm.monotone.database";

    static final String KEY_PROPERTY = "maven.scm.monotone.key";

    String getConfigDirectory();

    String getKeyringDirectory();

    String getDatabase() throws ScmRepositoryException;

    String getKey() throws ScmRepositoryException;
}
