/*
 * Decompiled with CFR 0.152.
 */
package org.criticalsection.maven.scm.provider.monotone.repository;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.criticalsection.maven.scm.provider.monotone.MonotoneSettingsProvider;

public class MonotoneScmProviderRepository
extends ScmProviderRepository {
    private static final Pattern SCM_URL_PATTERN = Pattern.compile("^local://(branch|tag)/(.*)$");
    private String branch;
    private String tag;
    private MonotoneSettingsProvider settingsProvider;

    public MonotoneScmProviderRepository(String url, MonotoneSettingsProvider provider) throws ScmRepositoryException {
        this.settingsProvider = provider;
        Matcher m = SCM_URL_PATTERN.matcher(url);
        if (!m.matches()) {
            throw new ScmRepositoryException("Unknown URL format.");
        }
        if (m.group(1).equals("branch")) {
            this.branch = m.group(2);
        } else {
            this.tag = m.group(2);
        }
    }

    public String getBranch() {
        return this.branch;
    }

    public String getTag() {
        return this.tag;
    }

    public String getConfigDirectory() {
        return this.settingsProvider.getConfigDirectory();
    }

    public String getKeyringDirectory() {
        return this.settingsProvider.getKeyringDirectory();
    }

    public String getDatabase() throws ScmRepositoryException {
        return this.settingsProvider.getDatabase();
    }

    public String getKey() throws ScmRepositoryException {
        return this.settingsProvider.getKey();
    }
}

