/*
 * Decompiled with CFR 0.152.
 */
package org.criticalsection.maven.scm.provider.monotone.command.tag;

import java.io.File;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.command.tag.AbstractTagCommand;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.codehaus.plexus.util.StringUtils;
import org.criticalsection.maven.scm.provider.monotone.MonotoneCommandlineUtils;
import org.criticalsection.maven.scm.provider.monotone.command.baserevision.BaseRevisionScmResult;
import org.criticalsection.maven.scm.provider.monotone.command.baserevision.MonotoneBaseRevisionCommand;
import org.criticalsection.maven.scm.provider.monotone.command.status.MonotoneStatusCommand;
import org.criticalsection.maven.scm.provider.monotone.repository.MonotoneScmProviderRepository;
import org.criticalsection.mtn4java.commands.Command;
import org.criticalsection.mtn4java.commands.invokers.InvokationException;
import org.criticalsection.mtn4java.commands.invokers.StandaloneInvoker;
import org.criticalsection.mtn4java.commands.standalone.TagCommand;

public class MonotoneTagCommand
extends AbstractTagCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ScmResult executeTagCommand(ScmProviderRepository repository, ScmFileSet fileSet, String tag, String message) throws ScmException {
        this.getLogger().debug("Executing tag command");
        if (tag == null || StringUtils.isEmpty((String)tag)) {
            throw new ScmException("Tag must be specified.");
        }
        if (fileSet.getFileList().size() != 0) {
            throw new ScmException("This provider doesn't support tagging subsets of a working copy.");
        }
        MonotoneStatusCommand statusCmd = new MonotoneStatusCommand();
        statusCmd.setLogger(this.getLogger());
        StatusScmResult statusResult = statusCmd.executeStatusCommand(repository, fileSet);
        if (!statusResult.isSuccess()) {
            return new TagScmResult(statusResult.getCommandLine(), "Error obtaining the status of the working copy.", statusResult.getCommandOutput(), false);
        }
        if (statusResult.getChangedFiles().size() != 0) {
            throw new ScmException("This provider doesn't support tagging of a working copy containing modified entries.");
        }
        MonotoneBaseRevisionCommand baseRevisionCmd = new MonotoneBaseRevisionCommand();
        baseRevisionCmd.setLogger(this.getLogger());
        BaseRevisionScmResult revisionResult = baseRevisionCmd.executeBaseRevisionCommand(repository, fileSet);
        if (!revisionResult.isSuccess()) {
            return new TagScmResult(revisionResult.getCommandLine(), "Error obtaining the base revision of the working copy.", revisionResult.getCommandOutput(), false);
        }
        File hookFile = MonotoneCommandlineUtils.createPassphraseHookInterceptor();
        Command cmd = this.createCommand(repository, hookFile, revisionResult.getBaseRevision(), tag);
        try {
            StandaloneInvoker invoker = new StandaloneInvoker("mtn", fileSet.getBasedir().getAbsolutePath());
            invoker.invoke(cmd);
        }
        catch (InvokationException e) {
            if (e.getType() == InvokationException.Type.PRECONDITION_ERROR) {
                TagScmResult tagScmResult = new TagScmResult("No commandline cvailable", "Precondition error during command execution.", e.getFormatedErrorMessage(), false);
                return tagScmResult;
            }
            if (e.getType() == InvokationException.Type.PROCESS_CREATION_ERROR) {
                TagScmResult tagScmResult = new TagScmResult(e.getCommandline(), "Error while crreating the external process during command execution.", e.getFormatedErrorMessage(), false);
                return tagScmResult;
            }
            if (e.getType() == InvokationException.Type.EXECUTION_ERROR) {
                TagScmResult tagScmResult = new TagScmResult(e.getCommandline(), "Error during command execution.", e.getFormatedErrorMessage(), false);
                return tagScmResult;
            }
        }
        finally {
            hookFile.delete();
        }
        return new TagScmResult(MonotoneCommandlineUtils.getWorkingCopyFiles(fileSet.getBasedir()), new ScmResult(null, null, null, true));
    }

    Command createCommand(ScmProviderRepository repository, File luaHook, String revision, String tag) throws ScmRepositoryException {
        MonotoneScmProviderRepository repo = (MonotoneScmProviderRepository)repository;
        TagCommand cmd = new TagCommand();
        if (repo.getConfigDirectory() != null && StringUtils.isNotEmpty((String)repo.getConfigDirectory())) {
            cmd.setConfigDirPath(repo.getConfigDirectory());
        }
        if (repo.getKeyringDirectory() != null && StringUtils.isNotEmpty((String)repo.getKeyringDirectory())) {
            cmd.setKeyDirPath(repo.getKeyringDirectory());
        }
        if (repo.getKey() != null && StringUtils.isNotEmpty((String)repo.getKey())) {
            cmd.setKey(repo.getKey());
        }
        cmd.setRcFilePath(luaHook.getAbsolutePath());
        cmd.setRevision(revision);
        cmd.setTagName(tag);
        return cmd;
    }
}

