/*
 * Decompiled with CFR 0.152.
 */
package org.criticalsection.maven.scm.provider.monotone.command.branch;

import java.io.File;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.branch.AbstractBranchCommand;
import org.apache.maven.scm.command.branch.BranchScmResult;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.codehaus.plexus.util.StringUtils;
import org.criticalsection.maven.scm.provider.monotone.MonotoneCommandlineUtils;
import org.criticalsection.maven.scm.provider.monotone.command.baserevision.BaseRevisionScmResult;
import org.criticalsection.maven.scm.provider.monotone.command.baserevision.MonotoneBaseRevisionCommand;
import org.criticalsection.maven.scm.provider.monotone.command.status.MonotoneStatusCommand;
import org.criticalsection.maven.scm.provider.monotone.repository.MonotoneScmProviderRepository;
import org.criticalsection.mtn4java.commands.Command;
import org.criticalsection.mtn4java.commands.invokers.InvokationException;
import org.criticalsection.mtn4java.commands.invokers.StandaloneInvoker;
import org.criticalsection.mtn4java.commands.standalone.CertCommand;

public class MonotoneBranchCommand
extends AbstractBranchCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ScmResult executeBranchCommand(ScmProviderRepository repository, ScmFileSet fileSet, String branchName, String message) throws ScmException {
        if (branchName == null || StringUtils.isEmpty((String)branchName)) {
            throw new ScmException("Branch name must be specified.");
        }
        if (fileSet.getFileList().size() != 0) {
            throw new ScmException("This provider doesn't support branching subsets of a working copy.");
        }
        MonotoneStatusCommand statusCmd = new MonotoneStatusCommand();
        statusCmd.setLogger(this.getLogger());
        StatusScmResult statusResult = statusCmd.executeStatusCommand(repository, fileSet);
        if (!statusResult.isSuccess()) {
            return new ScmResult(statusResult.getCommandLine(), "Error obtaining the status of the working copy.", statusResult.getCommandOutput(), false);
        }
        if (statusResult.getChangedFiles().size() != 0) {
            throw new ScmException("This provider doesn't support branching of a working copy containing modified entries.");
        }
        MonotoneBaseRevisionCommand baseRevisionCmd = new MonotoneBaseRevisionCommand();
        baseRevisionCmd.setLogger(this.getLogger());
        BaseRevisionScmResult revisionResult = baseRevisionCmd.executeBaseRevisionCommand(repository, fileSet);
        if (!revisionResult.isSuccess()) {
            return new ScmResult(revisionResult.getCommandLine(), "Error obtaining the base revision of the working copy.", revisionResult.getCommandOutput(), false);
        }
        File hookFile = MonotoneCommandlineUtils.createPassphraseHookInterceptor();
        Command cmd = this.createCommand(repository, hookFile, revisionResult.getBaseRevision(), branchName);
        try {
            StandaloneInvoker invoker = new StandaloneInvoker("mtn", fileSet.getBasedir().getAbsolutePath());
            invoker.invoke(cmd);
        }
        catch (InvokationException e) {
            if (e.getType() == InvokationException.Type.PRECONDITION_ERROR) {
                BranchScmResult branchScmResult = new BranchScmResult("No commandline cvailable", "Precondition error during command execution.", e.getFormatedErrorMessage(), false);
                return branchScmResult;
            }
            if (e.getType() == InvokationException.Type.PROCESS_CREATION_ERROR) {
                BranchScmResult branchScmResult = new BranchScmResult(e.getCommandline(), "Error while crreating the external process during command execution.", e.getFormatedErrorMessage(), false);
                return branchScmResult;
            }
            if (e.getType() == InvokationException.Type.EXECUTION_ERROR) {
                BranchScmResult branchScmResult = new BranchScmResult(e.getCommandline(), "Error during command execution.", e.getFormatedErrorMessage(), false);
                return branchScmResult;
            }
        }
        finally {
            hookFile.delete();
        }
        return new BranchScmResult(MonotoneCommandlineUtils.getWorkingCopyFiles(fileSet.getBasedir()), new ScmResult(null, null, null, true));
    }

    Command createCommand(ScmProviderRepository repository, File luaHook, String revision, String branch) throws ScmRepositoryException {
        MonotoneScmProviderRepository repo = (MonotoneScmProviderRepository)repository;
        CertCommand cmd = new CertCommand();
        if (repo.getConfigDirectory() != null && StringUtils.isNotEmpty((String)repo.getConfigDirectory())) {
            cmd.setConfigDirPath(repo.getConfigDirectory());
        }
        if (repo.getKeyringDirectory() != null && StringUtils.isNotEmpty((String)repo.getKeyringDirectory())) {
            cmd.setKeyDirPath(repo.getKeyringDirectory());
        }
        if (repo.getKey() != null && StringUtils.isNotEmpty((String)repo.getKey())) {
            cmd.setKey(repo.getKey());
        }
        cmd.setRcFilePath(luaHook.getAbsolutePath());
        cmd.setRevision(revision);
        cmd.setCertificateName("branch");
        cmd.setCertificateValue(branch);
        return cmd;
    }
}

