/*
 * Decompiled with CFR 0.152.
 */
package org.criticalsection.maven.scm.provider.monotone.command.add;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.add.AbstractAddCommand;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.codehaus.plexus.util.StringUtils;
import org.criticalsection.maven.scm.provider.monotone.repository.MonotoneScmProviderRepository;
import org.criticalsection.mtn4java.commands.Command;
import org.criticalsection.mtn4java.commands.invokers.InvokationException;
import org.criticalsection.mtn4java.commands.invokers.StandaloneInvoker;
import org.criticalsection.mtn4java.commands.standalone.AddCommand;

public class MonotoneAddCommand
extends AbstractAddCommand {
    protected ScmResult executeAddCommand(ScmProviderRepository repository, ScmFileSet fileSet, String message, boolean binary) throws ScmException {
        Command cmd;
        block7: {
            this.getLogger().debug("Executing add command");
            if (binary) {
                throw new ScmException("This provider does not support binary files");
            }
            if (fileSet.getFileList().size() == 0) {
                throw new ScmException("You must provide at least one file/directory to add");
            }
            cmd = this.createCommand(repository, fileSet.getFileList());
            try {
                StandaloneInvoker invoker = new StandaloneInvoker("mtn", fileSet.getBasedir().getAbsolutePath());
                invoker.invoke(cmd);
            }
            catch (InvokationException e) {
                if (e.getType() == InvokationException.Type.PRECONDITION_ERROR) {
                    return new AddScmResult("No commandline cvailable", "Precondition error during command execution.", e.getFormatedErrorMessage(), false);
                }
                if (e.getType() == InvokationException.Type.PROCESS_CREATION_ERROR) {
                    return new AddScmResult(e.getCommandline(), "Error while crreating the external process during command execution.", e.getFormatedErrorMessage(), false);
                }
                if (e.getType() != InvokationException.Type.EXECUTION_ERROR) break block7;
                return new AddScmResult(e.getCommandline(), "Error during command execution.", e.getFormatedErrorMessage(), false);
            }
        }
        ArrayList<ScmFile> addedFiles = new ArrayList<ScmFile>();
        List result = (List)cmd.getResult();
        Iterator i = result.iterator();
        while (i.hasNext()) {
            String curFile = (String)i.next();
            addedFiles.add(new ScmFile(curFile, ScmFileStatus.ADDED));
        }
        return new AddScmResult(addedFiles, new ScmResult(null, null, null, true));
    }

    Command createCommand(ScmProviderRepository repository, List files) throws ScmRepositoryException {
        MonotoneScmProviderRepository repo = (MonotoneScmProviderRepository)repository;
        AddCommand cmd = new AddCommand();
        if (repo.getConfigDirectory() != null && StringUtils.isNotEmpty((String)repo.getConfigDirectory())) {
            cmd.setConfigDirPath(repo.getConfigDirectory());
        }
        if (repo.getKeyringDirectory() != null && StringUtils.isNotEmpty((String)repo.getKeyringDirectory())) {
            cmd.setKeyDirPath(repo.getKeyringDirectory());
        }
        if (repo.getKey() != null && StringUtils.isNotEmpty((String)repo.getKey())) {
            cmd.setKey(repo.getKey());
        }
        ArrayList<String> filePaths = new ArrayList<String>();
        Iterator i = files.iterator();
        while (i.hasNext()) {
            File curFile = (File)i.next();
            filePaths.add(curFile.getPath());
        }
        cmd.setPathsToAdd(filePaths);
        return cmd;
    }
}

