package org.criticalsection.maven.scm.provider.monotone.repository;
/*
 * Copyright (C) 2008 Tim Kettler
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.codehaus.plexus.util.StringUtils;

import org.criticalsection.maven.scm.provider.monotone.MonotoneSettingsProvider;

import java.util.regex.Pattern;
import java.util.regex.Matcher;

public class MonotoneScmProviderRepository extends ScmProviderRepository
{
    private static final Pattern SCM_URL_PATTERN = Pattern.compile( "^local://(branch|tag)/(.*)$" );

    private String branch;

    private String tag;

    private MonotoneSettingsProvider settingsProvider;

    public MonotoneScmProviderRepository( String url, MonotoneSettingsProvider provider ) throws ScmRepositoryException
    {
        this.settingsProvider = provider;

        Matcher m = SCM_URL_PATTERN.matcher( url );

        if ( !m.matches() )
        {
            throw new ScmRepositoryException( "Unknown URL format." );
        }

        if ( m.group( 1 ).equals( "branch" ) )
        {
            this.branch = m.group( 2 );
        }
        else
        {
            this.tag = m.group( 2 );
        }
    }

    public String getBranch()
    {
        return branch;
    }

    public String getTag()
    {
        return tag;
    }

    public String getConfigDirectory()
    {
        return settingsProvider.getConfigDirectory();
    }

    public String getKeyringDirectory()
    {
        return settingsProvider.getKeyringDirectory();
    }

    public String getDatabase() throws ScmRepositoryException
    {
            return settingsProvider.getDatabase();
    }

    public String getKey() throws ScmRepositoryException
    {
            return settingsProvider.getKey();
    }
}
