package org.criticalsection.maven.scm.provider.monotone;
/*
 * Copyright (C) 2008 Tim Kettler
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.codehaus.plexus.util.FileUtils;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;

import java.util.List;
import java.util.Iterator;
import java.util.ArrayList;
import java.io.File;
import java.io.IOException;
import java.io.FilenameFilter;

public class MonotoneCommandlineUtils
{
    private static final String LUA_HOOK = "do\n"+
                                           "  local old_hook = get_passphrase\n"+
                                           "\n"+
                                           "  function get_passphrase(keypair_id)\n"+
                                           "    if old_hook == nil then\n"+
                                           "      return \"\"\n"+
                                           "    else\n"+
                                           "      return old_hook(keypair_id)\n"+
                                           "    end\n"+
                                           "  end\n"+
                                           "end";

    public static List getWorkingCopyFiles( File directory )
        throws ScmException
    {
        List fileList = new ArrayList();

        List files;

        try
        {
            files = FileUtils.getFiles( directory, "**", "**/_MTN/**", false );
        }
        catch ( IOException e )
        {
            throw new ScmException( "Error while executing command.", e );
        }

        for ( Iterator i = files.iterator(); i.hasNext(); )
        {
            File f = (File) i.next();

            fileList.add( new ScmFile( f.getPath(), ScmFileStatus.TAGGED ) );
        }

        return fileList;
    }

    /**
     * Create a temorary file with a lua 'get_passphrase' hook definition.
     *
     * This is a ugly hack!! monotone doesn't has a --non-interactive option
     * so that the process blocks forever asking the user for a password if
     * non is specified in the 'get_passphrase' hook.
     *
     * If one is present this hook return the result of the original 'get_passphrase'
     * hook else it returns an empty string, causing monotone to exit with an error.
     */
    public static File createPassphraseHookInterceptor() throws ScmException
    {
        File hookFile = FileUtils.createTempFile( "maven-scm-mtn-passphrase-interceptor", ".lua", null );

        try
        {
            FileUtils.fileWrite( hookFile.getAbsolutePath(), LUA_HOOK );
        }
        catch ( IOException ex )
        {
            throw new ScmException( "Error creating lua hook file." );
        }

        return hookFile;
    }

    /**
     * Searches upwards in the filesystem for a dir containing _MTN
     *
     * @param startPath
     * @return
     */
    public static String searchWorkspaceRoot( String startPath )
    {
        File curDir = new File( startPath );

        File[] files = curDir.listFiles( new FilenameFilter()
            {
                public boolean accept( File dir, String name )
                {
                    return name.equals( "_MTN" );
                }
            }
            );

        if ( files.length == 1 )
        {
            return curDir.getAbsolutePath();
        }
        else if ( curDir.getParentFile() != null )
        {
            return searchWorkspaceRoot( curDir.getParentFile().getAbsolutePath() );
        }
        else
        {
            return null;
        }
    }

    
}
