/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.git.config;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.craftercms.deployer.git.config.SiteConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class SiteConfigurationLoader {
    private static final Logger logger = LoggerFactory.getLogger(SiteConfigurationLoader.class);
    private String configurationLocation;

    public List<String> getSitesList() {
        logger.debug("Loading site list");
        ArrayList<String> sites = new ArrayList<String>();
        Path dir = Paths.get(this.configurationLocation, new String[0]);
        dir.toAbsolutePath().toString();
        logger.debug("Config location " + dir.toAbsolutePath().toString());
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir.toAbsolutePath());){
            for (Path entry : stream) {
                logger.debug("processing file " + entry.normalize().toString());
                Path filename = entry.getFileName();
                String strFilename = filename.toString();
                sites.add(strFilename.replaceAll(".yaml", ""));
            }
        }
        catch (IOException exc) {
            logger.error("Error while loading list of sites.", (Throwable)exc);
        }
        logger.debug("Found sites:");
        for (String site : sites) {
            logger.debug(site);
        }
        return sites;
    }

    public SiteConfiguration loadSiteConfiguration(String site) {
        SiteConfiguration siteConfiguration = null;
        Path siteConfigurationPath = Paths.get(this.configurationLocation, site + ".yaml");
        try (InputStream in = Files.newInputStream(siteConfigurationPath, new OpenOption[0]);){
            Yaml yaml = new Yaml();
            siteConfiguration = (SiteConfiguration)yaml.loadAs(in, SiteConfiguration.class);
            logger.debug("Configuration loaded for " + site);
            logger.debug(yaml.dump((Object)siteConfiguration));
        }
        catch (IOException exc) {
            logger.error("Error while loading site configuration from location " + siteConfigurationPath.normalize());
        }
        return siteConfiguration;
    }

    public String getConfigurationLocation() {
        return this.configurationLocation;
    }

    public void setConfigurationLocation(String configurationLocation) {
        this.configurationLocation = configurationLocation;
    }
}

