/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.cstudio.publishing.servlet;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.cstudio.publishing.PublishedChangeSet;
import org.craftercms.cstudio.publishing.exception.PublishingException;
import org.craftercms.cstudio.publishing.processor.PublishingProcessor;
import org.craftercms.cstudio.publishing.servlet.FileUploadServlet;
import org.craftercms.cstudio.publishing.target.PublishingTarget;
import org.craftercms.cstudio.publishing.target.TargetManager;

public class ReprocessServiceServlet
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(ReprocessServiceServlet.class);
    public static final String PARAM_PASSWORD = "password";
    public static final String PARAM_PROCESSOR = "processor";
    public static final String PARAM_TARGET = "target";
    protected TargetManager targetManager;
    private String password;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Map<String, String> parameters = this.getParameters(request);
        String password = parameters.get(PARAM_PASSWORD);
        PrintWriter responseWriter = response.getWriter();
        response.setContentType("text/plain");
        String paramTarget = parameters.get(PARAM_TARGET);
        if (password != null && password.equalsIgnoreCase(this.password)) {
            PublishingTarget target = this.targetManager.getTarget(paramTarget);
            if (target != null) {
                PublishingProcessor targetProcessor = null;
                String processorName = parameters.get(PARAM_PROCESSOR);
                if (!StringUtils.isEmpty((String)processorName)) {
                    List<PublishingProcessor> processors = target.getPostProcessors();
                    for (PublishingProcessor processor : processors) {
                        if (!processorName.equalsIgnoreCase(processor.getName())) continue;
                        targetProcessor = processor;
                        break;
                    }
                }
                if (targetProcessor != null) {
                    int status = this.reprocess(target, parameters, targetProcessor);
                    response.setStatus(status);
                    if (status == 200) {
                        responseWriter.println("Reprocess finished successfully");
                        LOGGER.info((Object)"Reprocess finished successfully");
                    } else {
                        responseWriter.println("Reprocess failed");
                        LOGGER.error((Object)"Reprocess failed");
                    }
                } else {
                    response.setStatus(400);
                    responseWriter.println("No processor found by name: " + processorName);
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn((Object)("No processor found by name: " + processorName));
                    }
                }
            } else {
                response.setStatus(400);
                responseWriter.println("No configuration exists for " + paramTarget);
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn((Object)("No configuration exists for " + paramTarget));
                }
            }
        } else {
            response.setStatus(401);
            responseWriter.println("Illegal publish request received. Password parameter does not match configured password for deployer.");
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn((Object)"Illegal publish request received. Password parameter does not match configured password for deployer.");
            }
        }
        responseWriter.flush();
    }

    private int reprocess(PublishingTarget target, Map<String, String> parameters, PublishingProcessor processor) {
        PublishedChangeSet changeSet = new PublishedChangeSet();
        StringBuilder sbFullPath = new StringBuilder(target.getParameter(FileUploadServlet.CONFIG_ROOT));
        sbFullPath.append(File.separator);
        sbFullPath.append(target.getParameter(FileUploadServlet.CONFIG_CONTENT_FOLDER));
        String fileRoot = sbFullPath.toString();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Root location: " + sbFullPath.toString()));
        }
        ArrayList<String> createdFiles = new ArrayList<String>();
        this.addToList(fileRoot, "", createdFiles);
        changeSet.setCreatedFiles(createdFiles);
        try {
            processor.doProcess(changeSet, parameters, target);
            return 200;
        }
        catch (PublishingException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)("Failed to reprocess target: " + target.getName()), (Throwable)e);
            }
            return 500;
        }
    }

    private Map<String, String> getParameters(HttpServletRequest request) {
        Enumeration paramNames = request.getParameterNames();
        HashMap<String, String> parameters = new HashMap<String, String>();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            String paramValue = request.getParameter(paramName);
            parameters.put(paramName, paramValue);
        }
        return parameters;
    }

    private void addToList(String fullPath, String sitePath, List<String> createdFiles) {
        URL resourceUrl;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Processing " + fullPath));
        }
        if ((resourceUrl = this.getResourceUrl(fullPath)) != null) {
            String resourcePath = resourceUrl.getFile();
            File file = new File(resourcePath);
            if (file.isDirectory()) {
                String[] children = file.list();
                if (children != null && children.length > 0) {
                    for (String childName : children) {
                        this.addToList(fullPath + "/" + childName, sitePath + "/" + childName, createdFiles);
                    }
                }
            } else {
                createdFiles.add(sitePath);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Added " + sitePath));
                }
            }
        }
    }

    private URL getResourceUrl(String filePath) {
        try {
            return new File(filePath).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Not able to find " + filePath);
        }
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setTargetManager(TargetManager targetManager) {
        this.targetManager = targetManager;
    }
}

