/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.cstudio.publishing.servlet;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.cstudio.publishing.PublishedChangeSet;
import org.craftercms.cstudio.publishing.exception.PublishingException;
import org.craftercms.cstudio.publishing.processor.PublishingProcessor;
import org.craftercms.cstudio.publishing.target.PublishingTarget;
import org.craftercms.cstudio.publishing.target.TargetManager;
import org.springframework.util.StringUtils;

public class FileUploadServlet
extends HttpServlet {
    private static final long serialVersionUID = 3281574055609732424L;
    private static Log LOGGER = LogFactory.getLog(FileUploadServlet.class);
    public static final String PARAM_PASSWORD = "password";
    public static String PARAM_SITE = "siteId";
    public static String PARAM_TARGET = "target";
    public static String PARAM_DELETED_FILES = "deletedFiles";
    public static String CONFIG_ROOT = "root";
    public static String CONFIG_CONTENT_FOLDER = "contentFolder";
    public static String CONFIG_METADATA_FOLDER = "metadataFolder";
    public static String CONFIG_METADATA_FILENAME_SUFFIX = ".meta.xml";
    public static String CONFIG_MULTI_TENANCY_VARIABLE = "\\{siteId\\}";
    public static String FILES_SEPARATOR = ",";
    protected TargetManager targetManager;
    private String password;

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            ServletFileUpload servletFileUpload = this.createServletFileUpload();
            List fileItemsList = null;
            HashMap<String, String> parameters = new HashMap<String, String>(11);
            HashMap<String, InputStream> files = new HashMap<String, InputStream>(11);
            try {
                String password;
                fileItemsList = servletFileUpload.parseRequest(request);
                for (FileItem fileItem : fileItemsList) {
                    if (fileItem.isFormField()) {
                        parameters.put(fileItem.getFieldName(), fileItem.getString());
                        continue;
                    }
                    files.put(fileItem.getFieldName(), fileItem.getInputStream());
                }
                if (LOGGER.isDebugEnabled()) {
                    StringBuilder parametersLog = new StringBuilder("Request Parameters : ");
                    for (Map.Entry entry : parameters.entrySet()) {
                        String key = (String)entry.getKey();
                        String value = (String)entry.getValue();
                        if (key.equals(PARAM_PASSWORD)) {
                            value = "********";
                        }
                        parametersLog.append(" " + key + " = " + value);
                    }
                    LOGGER.debug((Object)parametersLog.toString());
                }
                if ((password = (String)parameters.get(PARAM_PASSWORD)) != null && password.equalsIgnoreCase(this.password)) {
                    this.deployFiles(parameters, files);
                    response.setStatus(200);
                } else {
                    response.setStatus(401);
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn((Object)"Illegal publish request received. Password parameter does not match configured password for deployer.");
                    }
                }
            }
            catch (Exception e) {
                this.handleErrorCase(files, response, e);
            }
        }
    }

    private void handleErrorCase(Map<String, InputStream> files, HttpServletResponse response, Exception exception) {
        block3: {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to upload files.", (Throwable)exception);
            }
            this.closeAll(files);
            try {
                response.sendError(500, exception.getMessage());
            }
            catch (IOException e) {
                response.setStatus(500);
                if (!LOGGER.isErrorEnabled()) break block3;
                LOGGER.error((Object)"Failed to upload files.", (Throwable)e);
            }
        }
    }

    private void closeAll(Map<String, InputStream> files) {
        if (files != null) {
            for (String file : files.keySet()) {
                InputStream steam = files.get(file);
                IOUtils.closeQuietly((InputStream)steam);
            }
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected ServletFileUpload createServletFileUpload() {
        File repoPath;
        DiskFileItemFactory diskFileItemFactory = new DiskFileItemFactory();
        String tempPath = System.getProperty("java.io.tmpdir");
        if (tempPath == null) {
            tempPath = "temp";
        }
        if (!(repoPath = new File(tempPath + File.separator + "crafter")).exists()) {
            repoPath.mkdirs();
        }
        diskFileItemFactory.setRepository(repoPath);
        ServletFileUpload toRet = new ServletFileUpload((FileItemFactory)diskFileItemFactory);
        return toRet;
    }

    protected void deployFiles(Map<String, String> parameters, Map<String, InputStream> files) throws IOException {
        PublishedChangeSet changeSet;
        String paramTarget = parameters.get(PARAM_TARGET);
        PublishingTarget target = this.targetManager.getTarget(paramTarget);
        if (target != null) {
            changeSet = new PublishedChangeSet();
            this.writeToTarget(parameters, files, target, changeSet);
            this.deleteFromTarget(parameters, target, changeSet);
            if (target.isDefaultProcessingEnabled()) {
                try {
                    target.getDefaultPostProcessor().doProcess(changeSet, parameters, target);
                }
                catch (PublishingException e) {
                    LOGGER.error((Object)"Error while running a default post processor", (Throwable)e);
                }
            }
        } else {
            throw new IOException("No configuration exists for " + paramTarget);
        }
        this.doPostProcessing(changeSet, parameters, target);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void writeToTarget(Map<String, String> parameters, Map<String, InputStream> files, PublishingTarget target, PublishedChangeSet changeSet) throws IOException {
        ArrayList<String> createdFiles = new ArrayList<String>(files.size());
        ArrayList<String> updatedFiles = new ArrayList<String>(files.size());
        String site = parameters.get(PARAM_SITE);
        Iterator<Map.Entry<String, InputStream>> iterator = files.entrySet().iterator();
        while (true) {
            FileOutputStream outputStream;
            Map.Entry<String, InputStream> entry;
            block17: {
                if (!iterator.hasNext()) {
                    changeSet.setCreatedFiles(createdFiles);
                    changeSet.setUpdatedFiles(updatedFiles);
                    return;
                }
                entry = iterator.next();
                String locationParamName = entry.getKey().replace("File", "Location").replace("metadata", "content");
                boolean isMetadata = entry.getKey().startsWith("metadata");
                String contentLocation = parameters.get(locationParamName);
                StringBuilder sbFullPath = new StringBuilder(target.getParameter(CONFIG_ROOT));
                sbFullPath.append(File.separator);
                if (isMetadata) {
                    sbFullPath.append(target.getParameter(CONFIG_METADATA_FOLDER));
                } else {
                    sbFullPath.append(target.getParameter(CONFIG_CONTENT_FOLDER));
                }
                sbFullPath.append(contentLocation);
                if (isMetadata) {
                    sbFullPath.append(CONFIG_METADATA_FILENAME_SUFFIX);
                }
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)("writing " + sbFullPath.toString()));
                }
                String fullPath = sbFullPath.toString();
                if (StringUtils.hasText((String)site)) {
                    fullPath = fullPath.replaceAll(CONFIG_MULTI_TENANCY_VARIABLE, site);
                }
                File file = new File(fullPath);
                outputStream = null;
                try {
                    boolean created = false;
                    if (!file.exists()) {
                        file.getParentFile().mkdirs();
                        file.createNewFile();
                        created = true;
                    }
                    outputStream = new FileOutputStream(file);
                    IOUtils.copy((InputStream)entry.getValue(), (OutputStream)outputStream);
                    if (isMetadata) break block17;
                    if (created) {
                        createdFiles.add(contentLocation);
                    } else {
                        updatedFiles.add(contentLocation);
                    }
                }
                catch (FileNotFoundException e) {
                    try {
                        if (LOGGER.isErrorEnabled()) {
                            LOGGER.error((Object)("Error: not able to open output stream for file " + contentLocation + " for " + target.getName()));
                        }
                        throw e;
                        catch (IOException e2) {
                            if (LOGGER.isErrorEnabled()) {
                                LOGGER.error((Object)("Error: not able to write file " + contentLocation + " for " + target.getName()));
                            }
                            throw e2;
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly((InputStream)entry.getValue());
                        IOUtils.closeQuietly(outputStream);
                        throw throwable;
                    }
                }
            }
            IOUtils.closeQuietly((InputStream)entry.getValue());
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
    }

    protected void deleteFromTarget(Map<String, String> parameters, PublishingTarget target, PublishedChangeSet changeSet) {
        String deletedList = parameters.get(PARAM_DELETED_FILES);
        String site = parameters.get(PARAM_SITE);
        if (deletedList != null) {
            StringTokenizer tokens = new StringTokenizer(deletedList, FILES_SEPARATOR);
            ArrayList<String> deletedFiles = new ArrayList<String>(tokens.countTokens());
            while (tokens.hasMoreElements()) {
                File file;
                String contentLocation = tokens.nextToken();
                contentLocation = StringUtils.trimWhitespace((String)contentLocation);
                String root = target.getParameter(CONFIG_ROOT);
                String fullPath = root + File.separator + target.getParameter(CONFIG_CONTENT_FOLDER) + contentLocation;
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)("deleting " + fullPath));
                }
                if (StringUtils.hasText((String)site)) {
                    fullPath = fullPath.replaceAll(CONFIG_MULTI_TENANCY_VARIABLE, site);
                }
                if ((file = new File(fullPath)).exists()) {
                    if (file.isFile()) {
                        file.delete();
                        deletedFiles.add(contentLocation);
                    } else {
                        this.deleteChildren(file.list(), fullPath, contentLocation, deletedFiles);
                        file.delete();
                    }
                } else if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)(fullPath + " is not deleted since it does not exsit."));
                }
                fullPath = root + '/' + target.getParameter(CONFIG_METADATA_FOLDER) + contentLocation + CONFIG_METADATA_FILENAME_SUFFIX;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("deleting " + fullPath));
                }
                if (StringUtils.hasText((String)site)) {
                    fullPath = fullPath.replaceAll(CONFIG_MULTI_TENANCY_VARIABLE, site);
                }
                if ((file = new File(fullPath)).exists()) {
                    file.delete();
                    continue;
                }
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug((Object)(fullPath + " is not deleted since it does not exsit."));
            }
            changeSet.setDeletedFiles(deletedFiles);
        }
    }

    private void deleteChildren(String[] children, String parentFullPath, String parentPath, List<String> deletedFiles) {
        if (children != null) {
            for (String child : children) {
                String childFullPath = parentFullPath + File.separator + child;
                String childPath = parentPath + File.separator + child;
                File file = new File(childFullPath);
                if (file.isFile()) {
                    file.delete();
                    deletedFiles.add(childPath);
                    continue;
                }
                this.deleteChildren(file.list(), childFullPath, childPath, deletedFiles);
                file.delete();
            }
        }
    }

    protected void doPostProcessing(PublishedChangeSet changeSet, Map<String, String> parameters, PublishingTarget target) {
        List<PublishingProcessor> postProcessors = target.getPostProcessors();
        if (postProcessors != null) {
            try {
                for (PublishingProcessor processor : postProcessors) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("Running files through " + processor.getName()));
                    }
                    processor.doProcess(changeSet, parameters, target);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"Error while running a post processor", (Throwable)e);
            }
        }
    }

    public TargetManager getTargetManager() {
        return this.targetManager;
    }

    public void setTargetManager(TargetManager targetManager) {
        this.targetManager = targetManager;
    }
}

