/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.cstudio.publishing.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.craftercms.cstudio.publishing.servlet.FileUploadServlet;
import org.craftercms.cstudio.publishing.version.VersionException;
import org.craftercms.cstudio.publishing.version.VersioningService;

public class DeployVersionServlet
extends HttpServlet {
    private VersioningService versioningService;
    private static final long serialVersionUID = 4952629503662163667L;
    public static final String PARAM_NEW_VERSION = "version";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter serverOut = response.getWriter();
        try {
            String target = request.getParameter(FileUploadServlet.PARAM_TARGET);
            if (StringUtils.isEmpty((String)target)) {
                response.setStatus(400);
                serverOut.write("Parameter \"" + FileUploadServlet.PARAM_TARGET + "\" is need");
            } else {
                String currerntVersion = this.versioningService.readVersion(target);
                response.setStatus(200);
                serverOut.write(currerntVersion);
            }
        }
        catch (VersionException ex) {
            response.setStatus(500);
            serverOut.write(ex.getMessage());
        }
        this.setDefaultHeaders(response);
        serverOut.flush();
        response.flushBuffer();
    }

    private void setDefaultHeaders(HttpServletResponse response) {
        response.setHeader("Expires", "Sat, 6 May 1995 12:00:00 GMT");
        response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        response.addHeader("Cache-Control", "post-check=0, pre-check=0");
        response.setHeader("Pragma", "no-cache");
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter serverOut = response.getWriter();
        try {
            String target = request.getParameter(FileUploadServlet.PARAM_TARGET);
            String version = request.getParameter(PARAM_NEW_VERSION);
            if (StringUtils.isEmpty((String)target)) {
                response.setStatus(400);
                serverOut.write("Parameter \"" + FileUploadServlet.PARAM_TARGET + "\" is need and can not be empty");
            } else if (StringUtils.isEmpty((String)version)) {
                response.setStatus(400);
                serverOut.write("Parameter \"version\" is need and can not be empty");
            } else {
                this.versioningService.writeNewVersion(version, target);
                response.setStatus(200);
                serverOut.write(version);
            }
        }
        catch (VersionException ex) {
            response.setStatus(500);
            serverOut.write(ex.getMessage());
        }
        this.setDefaultHeaders(response);
        serverOut.flush();
        response.flushBuffer();
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    public void setVersioningService(VersioningService versioningService) {
        this.versioningService = versioningService;
    }
}

