/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.cstudio.publishing.processor;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.cstudio.publishing.PublishedChangeSet;
import org.craftercms.cstudio.publishing.exception.PublishingException;
import org.craftercms.cstudio.publishing.processor.AbstractPublishingProcessor;
import org.craftercms.cstudio.publishing.processor.SearchAttachmentProcessor;
import org.craftercms.cstudio.publishing.servlet.FileUploadServlet;
import org.craftercms.cstudio.publishing.target.PublishingTarget;
import org.craftercms.search.service.SearchService;

@Deprecated
public class SearchIndexBinaryFilesProcessor
extends AbstractPublishingProcessor {
    private static final Log logger = LogFactory.getLog(SearchAttachmentProcessor.class);
    private String siteName;
    private SearchService searchService;

    public void setSiteName(String siteName) {
        if (!StringUtils.isEmpty((String)siteName) && !"preview".equalsIgnoreCase(siteName)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Overriding site name in index with " + siteName));
            }
            this.siteName = siteName;
        }
    }

    public String getSiteName() {
        return this.siteName;
    }

    public SearchService getSearchService() {
        return this.searchService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    @Override
    public void doProcess(PublishedChangeSet changeSet, Map<String, String> parameters, PublishingTarget target) throws PublishingException {
        String root = target.getParameter(FileUploadServlet.CONFIG_ROOT);
        String contentFolder = target.getParameter(FileUploadServlet.CONFIG_CONTENT_FOLDER);
        String siteId = !StringUtils.isEmpty((String)this.siteName) ? this.siteName : parameters.get(FileUploadServlet.PARAM_SITE);
        root = root + "/" + contentFolder;
        if (org.springframework.util.StringUtils.hasText((String)siteId)) {
            root = root.replaceAll(FileUploadServlet.CONFIG_MULTI_TENANCY_VARIABLE, siteId);
        }
        List<String> createdFiles = changeSet.getCreatedFiles();
        List<String> updatedFiles = changeSet.getUpdatedFiles();
        List<String> deletedFiles = changeSet.getDeletedFiles();
        try {
            if (CollectionUtils.isNotEmpty(createdFiles)) {
                this.update(siteId, root, createdFiles, false);
            }
            if (CollectionUtils.isNotEmpty(updatedFiles)) {
                this.update(siteId, root, updatedFiles, false);
            }
            if (CollectionUtils.isNotEmpty(deletedFiles)) {
                this.update(siteId, root, deletedFiles, true);
            }
        }
        catch (Exception exc) {
            boolean bl = false;
        }
    }

    private void update(String siteId, String root, List<String> fileList, boolean isDelete) throws IOException {
        for (String fileName : fileList) {
            try {
                File file = new File(root + fileName);
                if (isDelete) {
                    this.searchService.delete(siteId, fileName);
                    continue;
                }
                this.searchService.updateDocument(siteId, fileName, file);
            }
            catch (Exception e) {
                logger.error((Object)("Failed to send update of file " + siteId + ":" + fileName), (Throwable)e);
            }
        }
    }
}

