/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.cstudio.publishing.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.cstudio.publishing.PublishedChangeSet;
import org.craftercms.cstudio.publishing.exception.PublishingException;
import org.craftercms.cstudio.publishing.processor.AbstractPublishingProcessor;
import org.craftercms.cstudio.publishing.processor.PublishingProcessor;
import org.craftercms.cstudio.publishing.servlet.FileUploadServlet;
import org.craftercms.cstudio.publishing.target.PublishingTarget;
import org.craftercms.search.service.Query;
import org.craftercms.search.service.SearchService;
import org.craftercms.search.service.impl.SolrQuery;
import org.springframework.beans.factory.annotation.Required;

public class ReIndexPagesOnComponentUpdateProcessor
extends AbstractPublishingProcessor {
    private static final Log logger = LogFactory.getLog(ReIndexPagesOnComponentUpdateProcessor.class);
    public static final String DEFAULT_COMPONENTS_ROOT = "/site/components";
    public static final String DEFAULT_PAGES_QUERY_PATTERN = "*:%s";
    protected String indexId;
    protected String defaultIndexIdFormat = "%s-default";
    protected boolean ignoreIndexId;
    protected String siteName;
    protected String componentsRoot = "/site/components";
    protected String pagesQueryPattern = "*:%s";
    protected SearchService searchService;
    protected PublishingProcessor actualIndexingProcessor;

    public void setIndexId(String indexId) {
        this.indexId = indexId;
    }

    public void setDefaultIndexIdFormat(String defaultIndexIdFormat) {
        this.defaultIndexIdFormat = defaultIndexIdFormat;
    }

    public void setIgnoreIndexId(boolean ignoreIndexId) {
        this.ignoreIndexId = ignoreIndexId;
    }

    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    public void setComponentsRoot(String componentsRoot) {
        this.componentsRoot = componentsRoot;
    }

    public void setPagesQueryPattern(String pagesQueryPattern) {
        this.pagesQueryPattern = pagesQueryPattern;
    }

    @Required
    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    @Required
    public void setActualIndexingProcessor(PublishingProcessor actualIndexingProcessor) {
        this.actualIndexingProcessor = actualIndexingProcessor;
    }

    @Override
    public void doProcess(PublishedChangeSet changeSet, Map<String, String> parameters, PublishingTarget target) throws PublishingException {
        String siteName = this.getActualSiteId(parameters);
        String indexId = this.getActualIndexId(siteName);
        List<String> createdFiles = changeSet.getCreatedFiles();
        List<String> updatedFiles = changeSet.getUpdatedFiles();
        List<String> deletedFiles = changeSet.getDeletedFiles();
        ArrayList<String> newUpdatedFiles = new ArrayList<String>(updatedFiles);
        for (String path : createdFiles) {
            if (!this.isComponent(path)) continue;
            this.addPagesThatIncludeComponentToUpdatedFiles(indexId, path, createdFiles, newUpdatedFiles);
        }
        for (String path : updatedFiles) {
            if (!this.isComponent(path)) continue;
            this.addPagesThatIncludeComponentToUpdatedFiles(indexId, path, createdFiles, newUpdatedFiles);
        }
        this.doIndexing(new PublishedChangeSet(createdFiles, newUpdatedFiles, deletedFiles), parameters, target);
    }

    protected void doIndexing(PublishedChangeSet changeSet, Map<String, String> parameters, PublishingTarget target) throws PublishingException {
        this.actualIndexingProcessor.doProcess(changeSet, parameters, target);
    }

    protected List<String> getPagesThatIncludeComponent(String indexId, String componentPath) {
        Query query = this.createPagesThatIncludeComponentQuery(componentPath);
        Map result = this.searchService.search(indexId, query);
        Map response = (Map)result.get("response");
        List documents = (List)response.get("documents");
        ArrayList<String> pages = new ArrayList<String>();
        for (Map document : documents) {
            pages.add((String)document.get("localId"));
        }
        return pages;
    }

    protected boolean isComponent(String path) {
        return path.startsWith(this.componentsRoot);
    }

    protected boolean isBeingUpdated(String path, List<String> createdFiles, List<String> updatedFiles) {
        return createdFiles.contains(path) || updatedFiles.contains(path);
    }

    protected void addPagesThatIncludeComponentToUpdatedFiles(String indexId, String component, List<String> createdFiles, List<String> updatedFiles) {
        List<String> pages = this.getPagesThatIncludeComponent(indexId, component);
        if (CollectionUtils.isNotEmpty(pages)) {
            for (String page : pages) {
                if (this.isBeingUpdated(page, createdFiles, updatedFiles)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Page " + page + " includes updated component " + component + ". Adding it to list of updated files."));
                }
                updatedFiles.add(page);
            }
        }
    }

    protected Query createPagesThatIncludeComponentQuery(String componentId) {
        String queryStatement = String.format(this.pagesQueryPattern, componentId);
        SolrQuery query = new SolrQuery();
        query.setQuery(queryStatement);
        query.setFieldsToReturn(new String[]{"localId"});
        return query;
    }

    protected String getActualSiteId(Map<String, String> parameters) {
        return StringUtils.isNotEmpty((CharSequence)this.siteName) ? this.siteName : parameters.get(FileUploadServlet.PARAM_SITE);
    }

    protected String getActualIndexId(String siteName) {
        if (this.ignoreIndexId) {
            return null;
        }
        return StringUtils.isNotEmpty((CharSequence)this.indexId) ? this.indexId : String.format(this.defaultIndexIdFormat, siteName);
    }
}

