/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.git.processor;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.cstudio.publishing.PublishedChangeSet;
import org.craftercms.cstudio.publishing.exception.PublishingException;
import org.craftercms.cstudio.publishing.servlet.FileUploadServlet;
import org.craftercms.deployer.git.config.SiteConfiguration;
import org.craftercms.deployer.git.processor.AbstractPublishingProcessor;

public class ShellProcessor
extends AbstractPublishingProcessor {
    private static final String INCLUDE_FILTER_PARAM = "includeFilter";
    private static final String INCLUDE_FILES_ARG = "files";
    private static Log LOGGER = LogFactory.getLog(ShellProcessor.class);
    private String workingDir;
    private String command;
    private Map<String, String> arguments;
    private Map<String, String> enviroment;
    private String sourceFiles;
    private boolean asSingleCommand;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doProcess(SiteConfiguration siteConfiguration, PublishedChangeSet changeSet) throws PublishingException {
        this.checkConfiguration(siteConfiguration);
        LOGGER.debug((Object)"Starting Shell Processor");
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.directory(this.getWorkingDir(this.workingDir, siteConfiguration.getSiteId()));
        LOGGER.debug((Object)("Working directory is " + this.workingDir));
        HashMap<String, String> argumentsMap = this.buildArgumentsMap(this.getFileList(changeSet));
        if (this.asSingleCommand) {
            StrSubstitutor substitutor = new StrSubstitutor(argumentsMap, "%{", "}");
            String execComand = substitutor.replace(this.command);
            LOGGER.debug((Object)("Command to be Executed is " + execComand));
            builder.command("/bin/bash", "-c", execComand);
        } else {
            Set<String> keys = argumentsMap.keySet();
            ArrayList<String> commandAsList = new ArrayList<String>();
            commandAsList.add(this.command.trim());
            for (String key : keys) {
                if (key.equalsIgnoreCase(INCLUDE_FILTER_PARAM)) continue;
                commandAsList.add(argumentsMap.get(key));
            }
            LOGGER.debug((Object)("Command to be Executed is " + StringUtils.join(commandAsList, (String)" ")));
            builder.command(commandAsList);
        }
        builder.environment().putAll(this.enviroment);
        builder.redirectErrorStream(true);
        try {
            String str;
            Process process = builder.start();
            process.waitFor();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((str = reader.readLine()) != null) {
                LOGGER.info((Object)("PROCESS OUTPUT :" + str));
            }
            reader.close();
            LOGGER.info((Object)("Process Finish with Exit Code " + process.exitValue()));
            LOGGER.debug((Object)"Process Output ");
        }
        catch (IOException ex) {
            LOGGER.error((Object)"Error ", (Throwable)ex);
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Error ", (Throwable)e);
        }
        finally {
            LOGGER.debug((Object)"End of Shell Processor");
        }
    }

    private File getWorkingDir(String workingDir, String siteId) {
        String actualWorkingDir = workingDir;
        if (actualWorkingDir.contains("{siteId}")) {
            actualWorkingDir = actualWorkingDir.replaceAll(FileUploadServlet.CONFIG_MULTI_TENANCY_VARIABLE, siteId);
        }
        return new File(actualWorkingDir);
    }

    private List<String> getFileList(PublishedChangeSet changeSet) {
        List<Object> result = new ArrayList();
        if (this.sourceFiles == null) {
            result = this.mergeList(changeSet.getCreatedFiles(), changeSet.getDeletedFiles(), changeSet.getUpdatedFiles());
        } else if (this.sourceFiles.equalsIgnoreCase("UPDATED")) {
            result = this.mergeList(changeSet.getUpdatedFiles());
        } else if (this.sourceFiles.equalsIgnoreCase("NEW")) {
            result = this.mergeList(changeSet.getCreatedFiles());
        } else if (this.sourceFiles.equalsIgnoreCase("EXISTENT")) {
            result = this.mergeList(changeSet.getCreatedFiles(), changeSet.getUpdatedFiles());
        } else if (this.sourceFiles.equalsIgnoreCase("DELETED")) {
            result = this.mergeList(changeSet.getDeletedFiles());
        } else {
            LOGGER.debug((Object)("Parameter " + this.sourceFiles + " has a non valid value, valid values (UPDATED,NEW,EXISTENT,DELETE)"));
            LOGGER.debug((Object)("Due non valid " + this.sourceFiles + " value returning empty list"));
        }
        for (int i = 0; i < result.size(); ++i) {
            result.set(i, ((String)result.get(i)).substring(1));
        }
        return Collections.unmodifiableList(result);
    }

    private void checkConfiguration(SiteConfiguration siteConfiguration) throws PublishingException {
        if (this.workingDir == null) {
            this.workingDir = this.buildContentPath(siteConfiguration);
            LOGGER.debug((Object)("working Dir is not set, using " + this.workingDir + " as default"));
        } else if (!this.getWorkingDir(this.workingDir, siteConfiguration.getSiteId()).exists()) {
            LOGGER.error((Object)("The path " + this.workingDir + " does not exist"));
            throw new PublishingException("The path " + this.workingDir + " does not exist");
        }
        if (this.command == null) {
            LOGGER.error((Object)"Command can't be Null");
            throw new PublishingException("Command can't be Null");
        }
        if (this.enviroment == null) {
            LOGGER.debug((Object)"There are non Enviroment Variables Overrides");
            this.enviroment = new HashMap<String, String>();
        } else {
            LOGGER.debug((Object)("Enviroment Overrides are " + this.enviroment.toString()));
        }
        if (this.sourceFiles == null) {
            LOGGER.debug((Object)"Using all files to apply includeFilter");
        }
    }

    protected String buildContentPath(SiteConfiguration siteConfiguration) throws PublishingException {
        LOGGER.debug((Object)"Building root Path");
        File directory = new File(".");
        String path = "";
        path = new File(siteConfiguration.getLocalRepositoryRoot()).exists() ? siteConfiguration.getLocalRepositoryRoot() : directory.getAbsolutePath().subSequence(0, directory.getAbsolutePath().length() - 2) + File.separator + siteConfiguration.getLocalRepositoryRoot();
        LOGGER.debug((Object)("Build path is " + path));
        return path;
    }

    protected HashMap<String, String> buildArgumentsMap(List<String> files) {
        String filter;
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.arguments != null) {
            result.putAll(this.arguments);
        }
        if ((filter = (String)result.get(INCLUDE_FILTER_PARAM)) != null) {
            ArrayList<String> filterFiles = new ArrayList<String>();
            Pattern patter = Pattern.compile(filter);
            for (String file : files) {
                if (patter.matcher(file).matches()) {
                    LOGGER.debug((Object)("File " + file + " Match " + filter));
                    filterFiles.add(file);
                    continue;
                }
                LOGGER.debug((Object)("File Don't " + file + " don't match " + filter));
            }
            result.put(INCLUDE_FILES_ARG, StringUtils.join(filterFiles, (String)" "));
        }
        return result;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public Map<String, String> getArguments() {
        return this.arguments;
    }

    public void setArguments(Map<String, String> arguments) {
        this.arguments = arguments;
    }

    public Map<String, String> getEnviroment() {
        return this.enviroment;
    }

    public void setEnviroment(Map<String, String> enviroment) {
        this.enviroment = enviroment;
    }

    public String getSourceFiles() {
        return this.sourceFiles;
    }

    public void setSourceFiles(String sourceFiles) {
        this.sourceFiles = sourceFiles;
    }

    public boolean isAsSingleCommand() {
        return this.asSingleCommand;
    }

    public void setAsSingleCommand(boolean asSingleCommand) {
        this.asSingleCommand = asSingleCommand;
    }

    private <T> List<T> mergeList(List<T> ... mergeWith) {
        ArrayList<T> mergeTo = new ArrayList<T>();
        for (List<T> toMerge : mergeWith) {
            if (toMerge == null) continue;
            mergeTo.addAll(toMerge);
        }
        return mergeTo;
    }
}

