/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.git.processor;

import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.cstudio.publishing.PublishedChangeSet;
import org.craftercms.cstudio.publishing.exception.PublishingException;
import org.craftercms.deployer.git.config.SiteConfiguration;
import org.craftercms.deployer.git.processor.AbstractPublishingProcessor;
import org.craftercms.deployer.git.processor.PublishingProcessor;

public class PerSiteConditionalProcessor
extends AbstractPublishingProcessor {
    private static final Log logger = LogFactory.getLog(PerSiteConditionalProcessor.class);
    protected Map<String, PublishingProcessor> processorMappings;
    protected PublishingProcessor defaultProcessor;

    public Map<String, PublishingProcessor> getProcessorMappings() {
        return this.processorMappings;
    }

    public void setProcessorMappings(Map<String, PublishingProcessor> processorMappings) {
        this.processorMappings = processorMappings;
    }

    public PublishingProcessor getDefaultProcessor() {
        return this.defaultProcessor;
    }

    public void setDefaultProcessor(PublishingProcessor defaultProcessor) {
        this.defaultProcessor = defaultProcessor;
    }

    @Override
    public void doProcess(SiteConfiguration siteConfiguration, PublishedChangeSet changeSet) throws PublishingException {
        String siteId = siteConfiguration.getSiteId();
        PublishingProcessor processor = null;
        if (MapUtils.isNotEmpty(this.processorMappings)) {
            processor = this.processorMappings.get(siteId);
        }
        if (processor == null) {
            processor = this.defaultProcessor;
        }
        if (processor != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Executing publishing processor " + processor.getName() + " for site " + siteId));
            }
            processor.doProcess(siteConfiguration, changeSet);
        }
    }
}

