/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.git.processor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.cstudio.publishing.PublishedChangeSet;
import org.craftercms.deployer.git.config.SiteConfiguration;
import org.craftercms.deployer.git.processor.AbstractPublishingProcessor;

public class CommandProcessor
extends AbstractPublishingProcessor {
    private static Log LOGGER = LogFactory.getLog(CommandProcessor.class);
    static final String STATUS_CREATED = "CREATED";
    static final String STATUS_UPDATED = "UPDATED";
    static final String STATUS_DELETED = "DELETED";
    private String command;
    private List<String> matchPatterns;

    @Override
    public void doProcess(SiteConfiguration siteConfiguration, PublishedChangeSet changeSet) {
        String root = siteConfiguration.getLocalRepositoryRoot();
        String siteId = siteConfiguration.getSiteId();
        this.processFiles(siteId, root, changeSet.getCreatedFiles(), STATUS_CREATED);
        this.processFiles(siteId, root, changeSet.getUpdatedFiles(), STATUS_UPDATED);
        this.processFiles(siteId, root, changeSet.getDeletedFiles(), STATUS_DELETED);
    }

    private void processFiles(String site, String root, List<String> files, String status) {
        if (files != null) {
            for (String file : files) {
                if (this.isMatchingPattern(file)) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("Processing " + file));
                    }
                    this.processFile(site, root, file, status);
                    continue;
                }
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug((Object)(file + " does not match a pattern."));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processFile(String site, String root, String file, String status) {
        BufferedReader reader = null;
        try {
            String fileCommand = this.command.replaceAll("SITE", site).replaceAll("ROOT", root).replaceAll("FILE", file).replaceAll("STATUS", status);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Running command with ProcessBuilder: " + fileCommand));
            }
            StringTokenizer tokenizer = new StringTokenizer(fileCommand, " ");
            ArrayList<String> processCommand = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                processCommand.add(tokenizer.nextToken());
            }
            ProcessBuilder pb = new ProcessBuilder(processCommand);
            pb.redirectErrorStream(true);
            Process process = pb.start();
            reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            if (LOGGER.isDebugEnabled()) {
                String line;
                while ((line = reader.readLine()) != null) {
                    LOGGER.debug((Object)line);
                }
            }
            process.waitFor();
            if (reader == null) return;
        }
        catch (IOException e) {
            LOGGER.error((Object)("Error while processing " + file), (Throwable)e);
            return;
        }
        catch (InterruptedException e2) {
            LOGGER.error((Object)("Error while processing " + file), (Throwable)e2);
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (reader != null) {
                IOUtils.closeQuietly(reader);
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return;
    }

    protected boolean isMatchingPattern(String file) {
        if (this.getMatchPatterns() != null) {
            for (String matchPattern : this.getMatchPatterns()) {
                if (file.matches(matchPattern)) {
                    System.out.println(file + " matched " + matchPattern);
                    return true;
                }
                System.out.println(file + " didn't match " + matchPattern);
            }
        }
        return true;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public List<String> getMatchPatterns() {
        return this.matchPatterns;
    }

    public void setMatchPatterns(List<String> matchPatterns) {
        this.matchPatterns = matchPatterns;
    }
}

