/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.git;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.collections4.CollectionUtils;
import org.craftercms.cstudio.publishing.PublishedChangeSet;
import org.craftercms.cstudio.publishing.exception.PublishingException;
import org.craftercms.deployer.git.config.SiteConfiguration;
import org.craftercms.deployer.git.config.SiteConfigurationLoader;
import org.craftercms.deployer.git.processor.PublishingProcessor;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitBasedDeployer {
    private static final Logger logger = LoggerFactory.getLogger(GitBasedDeployer.class);
    protected static final ReentrantLock singleWorkerLock = new ReentrantLock();
    private SiteConfigurationLoader siteConfigurationLoader;
    private boolean enabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        if (this.enabled && singleWorkerLock.tryLock()) {
            try {
                logger.debug("Loading configuration");
                List<String> sites = this.siteConfigurationLoader.getSitesList();
                for (String site : sites) {
                    SiteConfiguration siteConfiguration = this.siteConfigurationLoader.loadSiteConfiguration(site);
                    this.checkDeploymentUpdatesForSite(siteConfiguration);
                }
            }
            catch (Throwable err) {
                logger.error("unable to execute git deployer job", err);
            }
            finally {
                singleWorkerLock.unlock();
            }
        }
    }

    private void checkDeploymentUpdatesForSite(SiteConfiguration siteConfiguration) {
        try {
            Repository repository = this.getSiteRepository(siteConfiguration);
            ObjectId head = repository.resolve("HEAD");
            PullResult pullResult = this.pullFromRemoteRepo(repository);
            if (pullResult != null && pullResult.isSuccessful()) {
                MergeResult mergeResult = pullResult.getMergeResult();
                switch (mergeResult.getMergeStatus()) {
                    case FAST_FORWARD: {
                        ObjectId newHead = mergeResult.getNewHead();
                        PublishedChangeSet publishedChangeSet = this.processPull(repository, head, newHead);
                        this.doPostProcessing(siteConfiguration, publishedChangeSet);
                        break;
                    }
                    case ALREADY_UP_TO_DATE: {
                        break;
                    }
                    default: {
                        logger.error("Received unsupported merge result after executing pull command \nMerge Result: " + mergeResult.getMergeStatus().name());
                    }
                }
            }
        }
        catch (IOException exc) {
            logger.error("Error while checking for deployment updates for site " + siteConfiguration.getName(), (Throwable)exc);
        }
        catch (GitAPIException exc) {
            logger.error("Error while opening git repository for site " + siteConfiguration.getName(), (Throwable)exc);
        }
    }

    private Repository getSiteRepository(SiteConfiguration siteConfiguration) throws IOException, GitAPIException {
        Path siteRepoPath = Paths.get(siteConfiguration.getLocalRepositoryRoot(), new String[0]);
        Path siteLocalGitRepoPath = Paths.get(siteConfiguration.getLocalRepositoryRoot(), ".git");
        if (Files.exists(siteRepoPath, new LinkOption[0]) && Files.exists(siteLocalGitRepoPath, new LinkOption[0])) {
            return this.openRepository(siteLocalGitRepoPath.normalize().toAbsolutePath().toString());
        }
        Files.deleteIfExists(siteRepoPath);
        return this.cloneRemoteRepository(siteConfiguration.getGitRepositoryUrl(), siteConfiguration.getLocalRepositoryRoot());
    }

    private Repository openRepository(String localGitPath) throws IOException {
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        Repository repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)builder.setGitDir(new File(localGitPath))).readEnvironment()).findGitDir()).build();
        return repository;
    }

    private Repository cloneRemoteRepository(String remoteGitRepositoryUrl, String localRepositoryPath) throws GitAPIException {
        logger.debug("Cloning from " + remoteGitRepositoryUrl + " to " + localRepositoryPath);
        Path localGitRepositoryPath = Paths.get(localRepositoryPath, new String[0]);
        try (Git result = Git.cloneRepository().setURI(remoteGitRepositoryUrl).setDirectory(localGitRepositoryPath.toFile()).call();){
            logger.debug("Having repository: " + result.getRepository().getDirectory());
            Repository repository = result.getRepository();
            return repository;
        }
    }

    private PullResult pullFromRemoteRepo(Repository repository) {
        PullResult call = null;
        try (Git git = new Git(repository);){
            call = git.pull().call();
            logger.debug("Pulled from the remote repository: " + call);
        }
        catch (GitAPIException exc) {
            logger.error("Error while performing pull command for git repository " + repository.toString(), (Throwable)exc);
        }
        return call;
    }

    private PublishedChangeSet processPull(Repository repository, ObjectId oldHead, ObjectId newHead) throws IOException, GitAPIException {
        PublishedChangeSet changeSet = new PublishedChangeSet(new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>());
        RevWalk revWalk = new RevWalk(repository);
        RevCommit revCommit = revWalk.parseCommit((AnyObjectId)oldHead);
        ObjectId oldHeadTree = revCommit.getTree().getId();
        revCommit = revWalk.parseCommit((AnyObjectId)newHead);
        ObjectId newHeadTree = revCommit.getTree().getId();
        try (ObjectReader reader = repository.newObjectReader();){
            CanonicalTreeParser oldTreeIter = new CanonicalTreeParser();
            oldTreeIter.reset(reader, (AnyObjectId)oldHeadTree);
            CanonicalTreeParser newTreeIter = new CanonicalTreeParser();
            newTreeIter.reset(reader, (AnyObjectId)newHeadTree);
            try (Git git = new Git(repository);){
                List diffs = git.diff().setNewTree((AbstractTreeIterator)newTreeIter).setOldTree((AbstractTreeIterator)oldTreeIter).call();
                for (DiffEntry entry : diffs) {
                    logger.debug("Git Diff Entry: " + entry);
                    switch (entry.getChangeType()) {
                        case ADD: {
                            changeSet.getCreatedFiles().add(File.separator + entry.getNewPath());
                            break;
                        }
                        case MODIFY: {
                            changeSet.getUpdatedFiles().add(File.separator + entry.getNewPath());
                            break;
                        }
                        case DELETE: {
                            changeSet.getDeletedFiles().add(File.separator + entry.getOldPath());
                            break;
                        }
                        case RENAME: {
                            changeSet.getDeletedFiles().add(File.separator + entry.getOldPath());
                            changeSet.getCreatedFiles().add(File.separator + entry.getNewPath());
                        }
                    }
                }
            }
        }
        return changeSet;
    }

    private void doPostProcessing(SiteConfiguration siteConfiguration, PublishedChangeSet changeSet) {
        logger.debug("Change Set:\n" + changeSet.toString());
        List<PublishingProcessor> processors = siteConfiguration.getPostProcessors();
        if (CollectionUtils.isNotEmpty(processors)) {
            for (PublishingProcessor processor : processors) {
                try {
                    processor.doProcess(siteConfiguration, changeSet);
                }
                catch (PublishingException exc) {
                    logger.error("Error executing processor " + processor.getName() + " for site " + siteConfiguration.getName(), (Throwable)exc);
                }
            }
        }
    }

    public SiteConfigurationLoader getSiteConfigurationLoader() {
        return this.siteConfigurationLoader;
    }

    public void setSiteConfigurationLoader(SiteConfigurationLoader siteConfigurationLoader) {
        this.siteConfigurationLoader = siteConfigurationLoader;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

