/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.cstudio.publishing.version;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.cstudio.publishing.servlet.FileUploadServlet;
import org.craftercms.cstudio.publishing.target.PublishingTarget;
import org.craftercms.cstudio.publishing.target.TargetManager;
import org.craftercms.cstudio.publishing.version.VersionException;

public class VersioningService {
    protected static ReentrantLock fileLock = new ReentrantLock();
    private static final String DEFAULT_VERSION = "0";
    private static final int BUFFER_SIZE = 1024;
    private static Log LOGGER = LogFactory.getLog(VersioningService.class);
    protected String fileName;
    protected TargetManager targetManager;
    protected String charset;
    private Charset ioCharset;

    public void init() {
        this.ioCharset = Charset.forName(this.charset);
    }

    public void writeNewVersion(String newVersion, String targetName) throws VersionException {
        PublishingTarget target = this.targetManager.getTarget(targetName);
        FileOutputStream fout = null;
        File file = null;
        if (target == null) {
            LOGGER.error((Object)("Unable to get Target with name " + targetName));
            throw new VersionException("Unable to get Target with name " + targetName);
        }
        fileLock.lock();
        try {
            String path = target.getParameter(FileUploadServlet.CONFIG_ROOT);
            String finalName = path + File.separator + this.fileName;
            file = new File(finalName);
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            fout = new FileOutputStream(file);
            fout.write(newVersion.getBytes(this.ioCharset));
            fout.flush();
        }
        catch (IOException ioEx) {
            LOGGER.error((Object)("Unable to read or write file " + this.fileName), (Throwable)ioEx);
            throw new VersionException("Unable to read/write File " + this.fileName);
        }
        finally {
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (IOException ex) {
                LOGGER.error((Object)"Unable to IO resources", (Throwable)ex);
            }
            fileLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readVersion(String targetName) throws VersionException {
        String readVersion;
        block33: {
            PublishingTarget target = this.targetManager.getTarget(targetName);
            readVersion = DEFAULT_VERSION;
            if (target == null) {
                LOGGER.error((Object)("Unable to get Target with name " + targetName));
                throw new VersionException("Unable to get Target with name " + targetName);
            }
            fileLock.lock();
            try {
                String path = target.getParameter(FileUploadServlet.CONFIG_ROOT);
                String finalName = path + File.separator + this.fileName;
                File f = new File(finalName);
                if (f.exists()) {
                    LOGGER.debug((Object)("About to read " + finalName));
                    try (FileInputStream fin = new FileInputStream(f);
                         ByteArrayOutputStream out = new ByteArrayOutputStream();){
                        byte[] buff = new byte[1024];
                        while (fin.read(buff) >= 0) {
                            out.write(buff);
                        }
                        readVersion = new String(out.toByteArray(), this.charset);
                        if (StringUtils.isEmpty((String)readVersion)) {
                            readVersion = DEFAULT_VERSION;
                        }
                        break block33;
                    }
                    catch (IOException ioEx) {
                        LOGGER.error((Object)("Unable to read or write file " + this.fileName), (Throwable)ioEx);
                        throw new VersionException("Unable to read/write File " + this.fileName);
                    }
                }
                LOGGER.debug((Object)("Version File " + finalName + " does not exist returning default value"));
            }
            finally {
                fileLock.unlock();
            }
        }
        return readVersion;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setTargetManager(TargetManager targetManager) {
        this.targetManager = targetManager;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }
}

