/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.cstudio.publishing.target;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.cstudio.publishing.processor.PublishingProcessor;
import org.craftercms.cstudio.publishing.target.TargetManager;

public class PublishingTarget {
    private static Log LOGGER = LogFactory.getLog(PublishingTarget.class);
    private String name;
    private TargetManager manager;
    private Map<String, String> params;
    private List<PublishingProcessor> preProcessors;
    private List<PublishingProcessor> postProcessors;
    private PublishingProcessor defaultPostProcessor = null;
    private boolean defaultProcessingEnabled = false;

    public void register() {
        this.manager.register(this.name, this);
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public List<PublishingProcessor> getPreProcessors() {
        return this.preProcessors;
    }

    public void setPreProcessors(List<PublishingProcessor> preProcessors) {
        this.preProcessors = preProcessors;
    }

    public List<PublishingProcessor> getPostProcessors() {
        return this.postProcessors;
    }

    public void setPostProcessors(List<PublishingProcessor> postProcessors) {
        this.postProcessors = postProcessors;
    }

    public PublishingProcessor getDefaultPostProcessor() {
        return this.defaultPostProcessor;
    }

    public void setDefaultPostProcessor(PublishingProcessor defaultPostProcessor) {
        this.defaultPostProcessor = defaultPostProcessor;
    }

    public boolean isDefaultProcessingEnabled() {
        return this.defaultProcessingEnabled;
    }

    public void setDefaultProcessingEnabled(boolean defaultProcessingEnabled) {
        this.defaultProcessingEnabled = defaultProcessingEnabled;
    }

    public TargetManager getManager() {
        return this.manager;
    }

    public void setManager(TargetManager manager) {
        this.manager = manager;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getParameter(String name) {
        if (this.params != null) {
            return this.params.get(name);
        }
        return null;
    }

    public String toString() {
        return this.name;
    }
}

