/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.cstudio.publishing.processor;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.cstudio.publishing.PublishedChangeSet;
import org.craftercms.cstudio.publishing.exception.PublishingException;
import org.craftercms.cstudio.publishing.processor.AbstractPublishingProcessor;
import org.craftercms.cstudio.publishing.servlet.FileUploadServlet;
import org.craftercms.cstudio.publishing.target.PublishingTarget;
import org.craftercms.search.batch.utils.XmlUtils;
import org.craftercms.search.batch.utils.xml.DocumentProcessor;
import org.craftercms.search.batch.utils.xml.DocumentProcessorChain;
import org.craftercms.search.batch.utils.xml.FieldRenamingDocumentProcessor;
import org.craftercms.search.service.SearchService;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.springframework.beans.factory.annotation.Required;

@Deprecated
public class SearchUpdateProcessor
extends AbstractPublishingProcessor {
    private static final Log logger = LogFactory.getLog(SearchUpdateProcessor.class);
    protected SearchService searchService;
    protected String siteName;
    protected Map<String, String> fieldMappings;
    private String charEncoding = "UTF-8";
    protected DocumentProcessor documentProcessor;

    @Required
    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setSiteName(String siteName) {
        if (!StringUtils.isEmpty((String)siteName) && !"preview".equalsIgnoreCase(siteName)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Overriding site name in index with " + siteName));
            }
            this.siteName = siteName;
        }
    }

    public void setFieldMappings(Map<String, String> fieldMappings) {
        this.fieldMappings = fieldMappings;
    }

    public void setCharEncoding(String charEncoding) {
        this.charEncoding = charEncoding;
    }

    public void setTokenizeAttribute(String tokenizeAttribute) {
    }

    public void setTokenizeSubstitutionMap(Map<String, String> tokenizeSubstitutionMap) {
    }

    public void setDocumentProcessor(DocumentProcessor documentProcessor) {
        this.documentProcessor = documentProcessor;
    }

    @PostConstruct
    public void init() {
        if (this.documentProcessor == null) {
            List<DocumentProcessor> chain = this.createDocumentProcessorChain(new ArrayList<DocumentProcessor>());
            this.documentProcessor = new DocumentProcessorChain(chain);
        }
    }

    @Override
    public void doProcess(PublishedChangeSet changeSet, Map<String, String> parameters, PublishingTarget target) throws PublishingException {
        String root = target.getParameter(FileUploadServlet.CONFIG_ROOT);
        String contentFolder = target.getParameter(FileUploadServlet.CONFIG_CONTENT_FOLDER);
        String siteId = !StringUtils.isEmpty((String)this.siteName) ? this.siteName : parameters.get(FileUploadServlet.PARAM_SITE);
        root = root + "/" + contentFolder;
        if (StringUtils.isNotBlank((String)siteId)) {
            root = root.replaceAll(FileUploadServlet.CONFIG_MULTI_TENANCY_VARIABLE, siteId);
        }
        List<String> createdFiles = changeSet.getCreatedFiles();
        List<String> updatedFiles = changeSet.getUpdatedFiles();
        List<String> deletedFiles = changeSet.getDeletedFiles();
        if (CollectionUtils.isNotEmpty(createdFiles)) {
            this.update(siteId, root, createdFiles, false);
        }
        if (CollectionUtils.isNotEmpty(updatedFiles)) {
            this.update(siteId, root, updatedFiles, false);
        }
        if (CollectionUtils.isNotEmpty(deletedFiles)) {
            this.update(siteId, root, deletedFiles, true);
        }
        this.searchService.commit();
    }

    protected List<DocumentProcessor> createDocumentProcessorChain(List<DocumentProcessor> chain) {
        FieldRenamingDocumentProcessor processor = new FieldRenamingDocumentProcessor();
        if (MapUtils.isNotEmpty(this.fieldMappings)) {
            processor.setFieldMappings(this.fieldMappings);
        }
        chain.add((DocumentProcessor)processor);
        return chain;
    }

    protected void update(String siteId, String root, List<String> fileNames, boolean delete) throws PublishingException {
        for (String fileName : fileNames) {
            if (!fileName.endsWith(".xml")) continue;
            try {
                if (delete) {
                    this.searchService.delete(siteId, fileName);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)(siteId + ":" + fileName + " deleted from search index"));
                    continue;
                }
                try {
                    String xml = this.processXml(root, fileName);
                    this.searchService.update(siteId, fileName, xml, true);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)(siteId + ":" + fileName + " added to search index"));
                }
                catch (DocumentException e) {
                    logger.warn((Object)("Cannot process XML file " + siteId + ":" + fileName + ". Continuing index update..."), (Throwable)e);
                }
            }
            catch (Exception e) {
                logger.error((Object)("Failed to send update of file " + siteId + ":" + fileName), (Throwable)e);
            }
        }
    }

    protected String processXml(String root, String fileName) throws DocumentException {
        File file = new File(root + fileName);
        Document document = this.processDocument(XmlUtils.readXml((File)file, (String)this.charEncoding), file, root);
        String xml = document.asXML();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Processed XML:");
            logger.debug((Object)xml);
        }
        return xml;
    }

    protected Document processDocument(Document document, File file, String root) throws DocumentException {
        return this.documentProcessor.process(document, file, root);
    }
}

