/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.cstudio.publishing.processor;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.cstudio.publishing.PublishedChangeSet;
import org.craftercms.cstudio.publishing.exception.PublishingException;
import org.craftercms.cstudio.publishing.processor.AbstractPublishingProcessor;
import org.craftercms.cstudio.publishing.servlet.FileUploadServlet;
import org.craftercms.cstudio.publishing.target.PublishingTarget;
import org.craftercms.search.service.SearchService;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.util.StringUtils;

@Deprecated
public class SearchAttachmentWithExternalMetadataPostProcessor
extends AbstractPublishingProcessor {
    private static final Log logger = LogFactory.getLog(SearchAttachmentWithExternalMetadataPostProcessor.class);
    private String siteName;
    private SearchService searchService;
    private List<String> excludeProperties;
    private List<String> attachmentPathPatterns;
    private List<String> metadataPathPatterns;
    private List<String> referenceXpathList;
    private String multivalueSeparator = ",";
    private String charEncoding = "UTF-8";
    private String tokenizeAttribute = "tokenized";
    private Map<String, String> tokenizeSubstitutionMap = new HashMap<String, String>(){
        {
            this.put("_s", "_t");
            this.put("_smv", "_tmv");
        }
    };

    @Override
    public void doProcess(PublishedChangeSet changeSet, Map<String, String> parameters, PublishingTarget target) throws PublishingException {
        String root = target.getParameter(FileUploadServlet.CONFIG_ROOT);
        String contentFolder = target.getParameter(FileUploadServlet.CONFIG_CONTENT_FOLDER);
        String siteId = !org.apache.commons.lang.StringUtils.isEmpty((String)this.siteName) ? this.siteName : parameters.get(FileUploadServlet.PARAM_SITE);
        root = root + "/" + contentFolder;
        if (StringUtils.hasText((String)siteId)) {
            root = root.replaceAll(FileUploadServlet.CONFIG_MULTI_TENANCY_VARIABLE, siteId);
        }
        List<String> createdFiles = changeSet.getCreatedFiles();
        List<String> updatedFiles = changeSet.getUpdatedFiles();
        List<String> deletedFiles = changeSet.getDeletedFiles();
        try {
            if (CollectionUtils.isNotEmpty(createdFiles)) {
                this.processFiles(siteId, root, createdFiles, false);
            }
            if (CollectionUtils.isNotEmpty(updatedFiles)) {
                this.processFiles(siteId, root, updatedFiles, false);
            }
            if (CollectionUtils.isNotEmpty(deletedFiles)) {
                this.processFiles(siteId, root, deletedFiles, true);
            }
        }
        catch (Exception exc) {
            logger.error((Object)"Error: ", (Throwable)exc);
            throw new PublishingException("Failed to complete postprocessing.", exc);
        }
    }

    private void processFiles(String siteId, String root, List<String> fileList, boolean isDelete) throws IOException {
        for (String filePath : fileList) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("Processing file %s for site %s", filePath, siteId));
                }
                File file = new File(root + filePath);
                String updateIndexPath = filePath;
                Map<String, String> externalProperties = null;
                boolean searchIndexUpdate = false;
                if (!isDelete) {
                    if (this.isMetadataFile(filePath)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"Metadata processing started.");
                        }
                        SAXReader reader = new SAXReader();
                        try {
                            Document document = reader.read(file);
                            updateIndexPath = this.getAttachmentPath(document);
                            if (org.apache.commons.lang.StringUtils.isNotBlank((String)updateIndexPath)) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)"Extracting properties.");
                                }
                                Document parsedDocument = this.parseTokenizeAttribute(document);
                                externalProperties = this.parseMetadataFile(document);
                                file = new File(root + updateIndexPath);
                                if (!file.exists()) {
                                    File dir = file.getParentFile();
                                    dir.mkdirs();
                                    file.createNewFile();
                                }
                                searchIndexUpdate = true;
                            }
                        }
                        catch (DocumentException e) {
                            logger.error((Object)String.format("Error while opening xml file %s for site %s", filePath, siteId), (Throwable)e);
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"Metadata processing finished.");
                        }
                    } else if (this.isAttachmentFile(filePath)) {
                        searchIndexUpdate = true;
                    }
                }
                if (isDelete) {
                    this.searchService.delete(siteId, updateIndexPath);
                } else if (searchIndexUpdate) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)String.format("Sending search update request for file %s [%s] for site %s", updateIndexPath, filePath, siteId));
                    }
                    this.searchService.updateDocument(siteId, updateIndexPath, file, externalProperties);
                }
                this.searchService.commit();
            }
            catch (Exception e) {
                logger.error((Object)("Failed to send update of file " + siteId + ":" + filePath), (Throwable)e);
            }
        }
    }

    private Map<String, String> parseMetadataFile(Document document) {
        HashMap<String, String> properties = new HashMap<String, String>();
        Element root = document.getRootElement();
        this.processElementChildren(root, "", properties);
        return properties;
    }

    private void processElementChildren(Element element, String key, Map<String, String> properties) {
        int size = element.nodeCount();
        for (int i = 0; i < size; ++i) {
            String value;
            Node node = element.node(i);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Processing xml element %s", node.getPath()));
            }
            if (node instanceof Element) {
                StringBuilder sbPrefix = new StringBuilder(key);
                if (sbPrefix.length() > 0) {
                    sbPrefix.append(".");
                }
                sbPrefix.append(node.getName());
                if (this.excludeProperties.contains(sbPrefix.toString())) continue;
                this.processElementChildren((Element)node, sbPrefix.toString(), properties);
                continue;
            }
            StringBuilder sb = new StringBuilder();
            if (properties.containsKey(key)) {
                sb.append(properties.get(key));
                if (sb.length() > 0) {
                    sb.append(this.multivalueSeparator);
                }
            }
            if (!org.apache.commons.lang.StringUtils.isNotBlank((String)(value = node.getText()))) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Adding value [%s] for property [%s].", value, key));
            }
            sb.append(value);
            properties.put(key, org.apache.commons.lang.StringUtils.trim((String)sb.toString()));
        }
    }

    private String getAttachmentPath(Document document) {
        String referenceValue = "";
        for (String refXpath : this.referenceXpathList) {
            Node reference = document.selectSingleNode(refXpath);
            if (reference != null) {
                referenceValue = reference.getText();
            }
            if (!org.apache.commons.lang.StringUtils.isNotBlank((String)referenceValue)) continue;
            break;
        }
        return referenceValue;
    }

    private boolean isMetadataFile(String filePath) {
        boolean metadataFile = false;
        for (String metadataPattern : this.metadataPathPatterns) {
            Pattern pattern = Pattern.compile(metadataPattern);
            Matcher matcher = pattern.matcher(filePath);
            if (!matcher.matches()) continue;
            metadataFile = true;
            break;
        }
        return metadataFile;
    }

    private boolean isAttachmentFile(String filePath) {
        boolean metadataFile = false;
        for (String attachmentPattern : this.attachmentPathPatterns) {
            Pattern pattern = Pattern.compile(attachmentPattern);
            Matcher matcher = pattern.matcher(filePath);
            if (!matcher.matches()) continue;
            metadataFile = true;
            break;
        }
        return metadataFile;
    }

    private Document parseTokenizeAttribute(Document document) throws DocumentException {
        String tokenizeXpath = String.format("//*[@%s=\"true\"]", this.tokenizeAttribute);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Using tokenize XPath: " + tokenizeXpath));
        }
        List tokenizeElements = document.selectNodes(tokenizeXpath);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Number of elements found to perform tokenize parsing: " + tokenizeElements.size()));
        }
        if (CollectionUtils.isEmpty((Collection)tokenizeElements)) {
            return document;
        }
        for (Element tokenizeElement : tokenizeElements) {
            Element parent = tokenizeElement.getParent();
            String elemName = tokenizeElement.getName();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Parsing element: " + elemName));
            }
            for (String substitutionKey : this.tokenizeSubstitutionMap.keySet()) {
                if (!elemName.endsWith(substitutionKey)) continue;
                String newElementName = elemName.substring(0, elemName.length() - substitutionKey.length()) + this.tokenizeSubstitutionMap.get(substitutionKey);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Adding new element for tokenized search: " + newElementName));
                }
                Element newElement = tokenizeElement.createCopy(newElementName);
                parent.add(newElement);
            }
        }
        return document;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public void setSiteName(String siteName) {
        if (!org.apache.commons.lang.StringUtils.isEmpty((String)siteName) && !"preview".equalsIgnoreCase(siteName)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Overriding site name in index with " + siteName));
            }
            this.siteName = siteName;
        }
    }

    public SearchService getSearchService() {
        return this.searchService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public List<String> getExcludeProperties() {
        return this.excludeProperties;
    }

    public void setExcludeProperties(List<String> excludeProperties) {
        this.excludeProperties = excludeProperties;
    }

    public List<String> getAttachmentPathPatterns() {
        return this.attachmentPathPatterns;
    }

    public void setAttachmentPathPatterns(List<String> attachmentPathPatterns) {
        this.attachmentPathPatterns = attachmentPathPatterns;
    }

    public List<String> getMetadataPathPatterns() {
        return this.metadataPathPatterns;
    }

    public void setMetadataPathPatterns(List<String> metadataPathPatterns) {
        this.metadataPathPatterns = metadataPathPatterns;
    }

    public List<String> getReferenceXpathList() {
        return this.referenceXpathList;
    }

    public void setReferenceXpathList(List<String> referenceXpathList) {
        this.referenceXpathList = referenceXpathList;
    }

    public String getMultivalueSeparator() {
        return this.multivalueSeparator;
    }

    public void setMultivalueSeparator(String multivalueSeparator) {
        this.multivalueSeparator = multivalueSeparator;
    }

    public String getCharEncoding() {
        return this.charEncoding;
    }

    public void setCharEncoding(String charEncoding) {
        this.charEncoding = charEncoding;
    }

    public String getTokenizeAttribute() {
        return this.tokenizeAttribute;
    }

    public void setTokenizeAttribute(String tokenizeAttribute) {
        this.tokenizeAttribute = tokenizeAttribute;
    }

    public Map<String, String> getTokenizeSubstitutionMap() {
        return this.tokenizeSubstitutionMap;
    }

    public void setTokenizeSubstitutionMap(Map<String, String> tokenizeSubstitutionMap) {
        this.tokenizeSubstitutionMap = tokenizeSubstitutionMap;
    }
}

