/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.cstudio.publishing.processor;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.activation.MimetypesFileTypeMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.cstudio.publishing.PublishedChangeSet;
import org.craftercms.cstudio.publishing.exception.PublishingException;
import org.craftercms.cstudio.publishing.processor.AbstractPublishingProcessor;
import org.craftercms.cstudio.publishing.servlet.FileUploadServlet;
import org.craftercms.cstudio.publishing.target.PublishingTarget;
import org.craftercms.search.service.SearchService;
import org.springframework.beans.factory.annotation.Required;

@Deprecated
public class SearchAttachmentProcessor
extends AbstractPublishingProcessor {
    private static final Log logger = LogFactory.getLog(SearchAttachmentProcessor.class);
    private String siteName;
    private SearchService searchService;
    private List<String> supportedMimeTypes;

    public void setSiteName(String siteName) {
        if (!StringUtils.isEmpty((String)siteName) && !"preview".equalsIgnoreCase(siteName)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Overriding site name in index with " + siteName));
            }
            this.siteName = siteName;
        }
    }

    public String getSiteName() {
        return this.siteName;
    }

    public SearchService getSearchService() {
        return this.searchService;
    }

    @Required
    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public List<String> getSupportedMimeTypes() {
        return this.supportedMimeTypes;
    }

    @Required
    public void setSupportedMimeTypes(List<String> supportedMimeTypes) {
        this.supportedMimeTypes = supportedMimeTypes;
    }

    @Override
    public void doProcess(PublishedChangeSet changeSet, Map<String, String> parameters, PublishingTarget target) throws PublishingException {
        String root = target.getParameter(FileUploadServlet.CONFIG_ROOT);
        String contentFolder = target.getParameter(FileUploadServlet.CONFIG_CONTENT_FOLDER);
        String siteId = !StringUtils.isEmpty((String)this.siteName) ? this.siteName : parameters.get(FileUploadServlet.PARAM_SITE);
        root = root + "/" + contentFolder;
        if (org.springframework.util.StringUtils.hasText((String)siteId)) {
            root = root.replaceAll(FileUploadServlet.CONFIG_MULTI_TENANCY_VARIABLE, siteId);
        }
        List<String> createdFiles = changeSet.getCreatedFiles();
        List<String> updatedFiles = changeSet.getUpdatedFiles();
        List<String> deletedFiles = changeSet.getDeletedFiles();
        try {
            if (CollectionUtils.isNotEmpty(createdFiles)) {
                this.update(siteId, root, createdFiles, false);
            }
            if (CollectionUtils.isNotEmpty(updatedFiles)) {
                this.update(siteId, root, updatedFiles, false);
            }
            if (CollectionUtils.isNotEmpty(deletedFiles)) {
                this.update(siteId, root, deletedFiles, true);
            }
        }
        catch (Exception exc) {
            boolean bl = false;
        }
    }

    private void update(String siteId, String root, List<String> fileList, boolean isDelete) throws IOException {
        for (String fileName : fileList) {
            try {
                String mimeType = null;
                File file = new File(root + fileName);
                MimetypesFileTypeMap mimeTypesMap = new MimetypesFileTypeMap();
                mimeType = mimeTypesMap.getContentType(fileName);
                if (this.supportedMimeTypes.contains(mimeType) && !isDelete) {
                    this.searchService.updateDocument(siteId, fileName, file);
                    continue;
                }
                if (!isDelete) continue;
                this.searchService.delete(siteId, fileName);
            }
            catch (Exception e) {
                logger.error((Object)("Failed to send update of file " + siteId + ":" + fileName), (Throwable)e);
            }
        }
    }
}

