/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.cstudio.publishing.processor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.commons.lang.RegexUtils;
import org.craftercms.cstudio.publishing.PublishedChangeSet;
import org.craftercms.cstudio.publishing.exception.PublishingException;
import org.craftercms.cstudio.publishing.processor.AbstractPublishingProcessor;
import org.craftercms.cstudio.publishing.processor.PublishingProcessor;
import org.craftercms.cstudio.publishing.target.PublishingTarget;
import org.springframework.beans.factory.annotation.Required;

public class OnPathMatchConditionalProcessor
extends AbstractPublishingProcessor {
    private static final Log logger = LogFactory.getLog(OnPathMatchConditionalProcessor.class);
    protected Map<String[], PublishingProcessor> processorMappings;

    public Map<String[], PublishingProcessor> getProcessorMappings() {
        return this.processorMappings;
    }

    @Required
    public void setProcessorMappings(Map<String[], PublishingProcessor> processorMappings) {
        this.processorMappings = processorMappings;
    }

    @Override
    public void doProcess(PublishedChangeSet changeSet, Map<String, String> parameters, PublishingTarget target) throws PublishingException {
        List<String> createdFiles = this.copyFileList(changeSet.getCreatedFiles());
        List<String> updatedFiles = this.copyFileList(changeSet.getUpdatedFiles());
        List<String> deletedFiles = this.copyFileList(changeSet.getDeletedFiles());
        for (Map.Entry<String[], PublishingProcessor> entry : this.processorMappings.entrySet()) {
            String path;
            String[] patterns = entry.getKey();
            PublishingProcessor processor = entry.getValue();
            ArrayList<String> matchedCreatedFiles = new ArrayList<String>();
            ArrayList<String> matchedUpdatedFiles = new ArrayList<String>();
            ArrayList<String> matchedDeletedFiles = new ArrayList<String>();
            Iterator<String> iter = createdFiles.iterator();
            while (iter.hasNext()) {
                path = iter.next();
                if (!RegexUtils.matchesAny((String)path, (String[])patterns)) continue;
                matchedCreatedFiles.add(path);
                iter.remove();
            }
            iter = updatedFiles.iterator();
            while (iter.hasNext()) {
                path = iter.next();
                if (!RegexUtils.matchesAny((String)path, (String[])patterns)) continue;
                matchedUpdatedFiles.add(path);
                iter.remove();
            }
            iter = deletedFiles.iterator();
            while (iter.hasNext()) {
                path = iter.next();
                if (!RegexUtils.matchesAny((String)path, (String[])patterns)) continue;
                matchedDeletedFiles.add(path);
                iter.remove();
            }
            if (!CollectionUtils.isNotEmpty(matchedCreatedFiles) && !CollectionUtils.isNotEmpty(matchedUpdatedFiles) && !CollectionUtils.isNotEmpty(matchedDeletedFiles)) continue;
            PublishedChangeSet newChangeSet = new PublishedChangeSet();
            newChangeSet.setCreatedFiles(matchedCreatedFiles);
            newChangeSet.setUpdatedFiles(matchedUpdatedFiles);
            newChangeSet.setDeletedFiles(deletedFiles);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Executing publishing processor " + processor.getName() + " for " + newChangeSet));
            }
            processor.doProcess(newChangeSet, parameters, target);
        }
    }

    @Override
    public String getName() {
        return OnPathMatchConditionalProcessor.class.getSimpleName();
    }

    protected List<String> copyFileList(List<String> files) {
        return CollectionUtils.isNotEmpty(files) ? new ArrayList<String>(files) : Collections.emptyList();
    }
}

