/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.cstudio.publishing.processor;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.TraceMethod;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.cstudio.publishing.PublishedChangeSet;
import org.craftercms.cstudio.publishing.exception.PublishingException;
import org.craftercms.cstudio.publishing.processor.AbstractPublishingProcessor;
import org.craftercms.cstudio.publishing.servlet.FileUploadServlet;
import org.craftercms.cstudio.publishing.target.PublishingTarget;
import org.springframework.beans.factory.annotation.Required;

public class HttpMethodCallPostProcessor
extends AbstractPublishingProcessor {
    private static final Log logger = LogFactory.getLog(HttpMethodCallPostProcessor.class);
    protected Method method;
    protected String url;
    protected String siteName;

    public Method getMethod() {
        return this.method;
    }

    @Required
    public void setMethod(Method method) {
        this.method = method;
    }

    public String getUrl() {
        return this.url;
    }

    @Required
    public void setUrl(String url) {
        this.url = url;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    @Override
    public void doProcess(PublishedChangeSet changeSet, Map<String, String> parameters, PublishingTarget target) throws PublishingException {
        String siteId;
        String url = this.url;
        String string = siteId = StringUtils.isNotEmpty((String)this.siteName) ? this.siteName : parameters.get(FileUploadServlet.PARAM_SITE);
        if (StringUtils.isNotEmpty((String)siteId)) {
            url = url.replaceAll(FileUploadServlet.CONFIG_MULTI_TENANCY_VARIABLE, siteId);
        }
        HttpMethod httpMethod = this.createHttpMethod(url);
        HttpClient client = new HttpClient();
        try {
            int status = client.executeMethod(httpMethod);
            String msg = (Object)((Object)this.method) + " " + url + " response: status = " + status + ", body = " + httpMethod.getResponseBodyAsString();
            if (status == 200) {
                logger.info((Object)msg);
            } else {
                logger.error((Object)msg);
            }
        }
        catch (IOException e) {
            throw new PublishingException(e);
        }
        finally {
            httpMethod.releaseConnection();
        }
    }

    @Override
    public String getName() {
        return HttpMethodCallPostProcessor.class.getName();
    }

    protected HttpMethod createHttpMethod(String url) {
        switch (this.method) {
            case GET: {
                return new GetMethod(url);
            }
            case POST: {
                return new PostMethod(url);
            }
            case HEAD: {
                return new HeadMethod(url);
            }
            case OPTIONS: {
                return new OptionsMethod(url);
            }
            case PUT: {
                return new PutMethod(url);
            }
            case DELETE: {
                return new DeleteMethod(url);
            }
        }
        return new TraceMethod(url);
    }

    public static enum Method {
        GET,
        POST,
        HEAD,
        OPTIONS,
        PUT,
        DELETE,
        TRACE;

    }
}

