/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.cstudio.publishing.processor;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.cstudio.publishing.PublishedChangeSet;
import org.craftercms.cstudio.publishing.exception.PublishingException;
import org.craftercms.cstudio.publishing.processor.AbstractPublishingProcessor;
import org.craftercms.cstudio.publishing.servlet.FileUploadServlet;
import org.craftercms.cstudio.publishing.target.PublishingTarget;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class EmailProcessor
extends AbstractPublishingProcessor {
    private static Log LOGGER = LogFactory.getLog(EmailProcessor.class);
    private static String PAGE_ROOT = "/site/website";
    private static String PROTOCOL_SMTPS = "smtps";
    private static String PROTOCOL_TLS = "tls";
    private static String MAIL_SMTP_AUTH = "mail.smtp.auth";
    private static String MAIL_SMTP_HOST = "mail.smtp.host";
    private static String MAIL_SMTP_PORT = "mail.smtp.port";
    private static String MAIL_SMTP_SSL = "mail.smtp.ssl.enable";
    private static String MAIL_SMTP_STARTTLS = "mail.smtp.starttls.enable";
    public static String CHAR_ENCODING = "UTF-8";
    private String host;
    private String port;
    private String username;
    private String password;
    private String protocol;
    private boolean authenticated;
    private String defaultMailFrom;
    private String previewUrl;
    private String componentController;
    private String siteName;
    private Map<String, String> headers;
    private List<String> matchPatterns;
    private List<String> positiveChecks;
    private List<String> negativeChecks;
    private String mailToPath;
    private String mailCcPath;
    private String mailBccPath;
    private String mailFromPath;
    private String replyToPath;
    private String titlePath;
    private String textContentPath;
    private String sendEmailFlagPath;
    private String imagePattern;
    private Map<String, String> urlReplacements;
    private Map<String, String> contentReplacements;

    @Override
    public void doProcess(PublishedChangeSet changeSet, Map<String, String> parameters, PublishingTarget target) throws PublishingException {
        String root = target.getParameter(FileUploadServlet.CONFIG_ROOT);
        String contentFolder = target.getParameter(FileUploadServlet.CONFIG_CONTENT_FOLDER);
        root = root + "/" + contentFolder;
        String siteId = StringUtils.isEmpty((String)this.getSiteName()) ? parameters.get(FileUploadServlet.PARAM_SITE) : this.getSiteName();
        this.processFiles(siteId, root, changeSet.getCreatedFiles());
        this.processFiles(siteId, root, changeSet.getUpdatedFiles());
    }

    protected void processFiles(String site, String root, List<String> files) {
        if (files != null) {
            for (String file : files) {
                if (this.isMatchingPattern(file)) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("Processing " + file));
                    }
                    try {
                        this.processFile(site, root, file);
                    }
                    catch (PublishingException e) {
                        LOGGER.error((Object)("Error while processing " + file), (Throwable)e);
                    }
                    continue;
                }
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug((Object)(file + " does not match a pattern."));
            }
        }
    }

    protected void processFile(String site, String root, String file) throws PublishingException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Processing " + file));
        }
        try {
            SAXReader reader = new SAXReader();
            reader.setEncoding(this.getCharEncoding());
            Document document = reader.read(root + file);
            Element rootEl = document.getRootElement();
            String sendEmailFlag = rootEl.valueOf(this.getSendEmailFlagPath());
            if (StringUtils.isEmpty((String)sendEmailFlag) || sendEmailFlag.equalsIgnoreCase("true")) {
                List<Address> mailToList = this.getEmailList(rootEl, this.getMailToPath());
                List<Address> mailCcList = this.getEmailList(rootEl, this.getMailCcPath());
                List<Address> mailBccList = this.getEmailList(rootEl, this.getMailBccPath());
                if (CollectionUtils.isEmpty(mailToList) && CollectionUtils.isEmpty(mailCcList) && CollectionUtils.isEmpty(mailBccList)) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)"No recipient is set. Skipping.");
                    }
                } else {
                    String mailFromStr = rootEl.valueOf(this.getMailFromPath());
                    if (StringUtils.isEmpty((String)mailFromStr)) {
                        mailFromStr = this.getDefaultMailFrom();
                    }
                    Address mailFromAddress = this.createEmailAddress(mailFromStr);
                    List<Address> replyToList = this.getEmailList(rootEl, this.getReplyToPath());
                    String title = rootEl.valueOf(this.getTitlePath());
                    String textContent = rootEl.valueOf(this.getTextContentPath());
                    String htmlContent = this.getHtmlContent(file, site);
                    this.sendEmail(root, mailFromAddress, replyToList, mailToList, mailCcList, mailBccList, title, htmlContent, textContent);
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("sendEmailFlag: " + sendEmailFlag));
            }
        }
        catch (IOException e) {
            throw new PublishingException(e);
        }
        catch (DocumentException e) {
            throw new PublishingException((Exception)((Object)e));
        }
    }

    protected List<Address> getEmailList(Element parentEl, String path) {
        ArrayList<Address> emailList;
        block4: {
            block3: {
                emailList = null;
                if (!path.contains("//")) break block3;
                List mailNodes = parentEl.selectNodes(path);
                if (CollectionUtils.isEmpty((Collection)mailNodes)) break block4;
                emailList = new ArrayList<Address>();
                for (Node mailNode : mailNodes) {
                    Address address = this.createEmailAddress(mailNode.getText());
                    if (address == null) continue;
                    emailList.add(address);
                }
                break block4;
            }
            String listStr = parentEl.valueOf(path);
            if (!StringUtils.isEmpty((String)listStr)) {
                emailList = new ArrayList();
                StringTokenizer tokenizer = new StringTokenizer(listStr, ";");
                while (tokenizer.hasMoreTokens()) {
                    Address address = this.createEmailAddress(tokenizer.nextToken());
                    if (address == null) continue;
                    emailList.add(address);
                }
            }
        }
        return emailList;
    }

    protected Address createEmailAddress(String emailStr) {
        block8: {
            if (!StringUtils.isEmpty((String)emailStr)) {
                String email = null;
                String name = null;
                int index = emailStr.indexOf("<");
                if (index > 0 && index < emailStr.length() - 1) {
                    name = emailStr.substring(0, index).trim();
                    email = emailStr.substring(index + 1, emailStr.length() - 1).trim();
                } else {
                    email = emailStr.trim();
                }
                if (email.length() > 0) {
                    try {
                        InternetAddress address = StringUtils.isEmpty(name) ? new InternetAddress(email) : new InternetAddress(email, name, this.getCharEncoding());
                        return address;
                    }
                    catch (AddressException e) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)(email + " is not a valid email address."));
                        }
                    }
                    catch (UnsupportedEncodingException e) {
                        if (!LOGGER.isDebugEnabled()) break block8;
                        LOGGER.debug((Object)"Error while creating an email address.", (Throwable)e);
                    }
                }
            }
        }
        return null;
    }

    protected void sendEmail(String root, Address mailFrom, List<Address> replyToList, List<Address> mailToList, List<Address> mailCcList, List<Address> mailBccList, String title, String htmlContent, String textContent) throws PublishingException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Sending email from: " + mailFrom));
            LOGGER.debug((Object)("to: " + mailToList + ", cc: " + mailCcList + ", bcc: " + mailBccList));
            LOGGER.debug((Object)("reply to: " + replyToList));
            LOGGER.debug((Object)("title: " + title));
            LOGGER.debug((Object)("text content: " + textContent));
        }
        try {
            Session session = this.createSession();
            MimeMultipart multipart = new MimeMultipart("alternative");
            MimeBodyPart textPart = new MimeBodyPart();
            textPart.setText(textContent);
            multipart.addBodyPart((BodyPart)textPart);
            MimeBodyPart htmlPart = new MimeBodyPart();
            htmlContent = this.embedImages(root, (Multipart)multipart, htmlContent);
            htmlPart.setContent((Object)htmlContent, "text/html");
            multipart.addBodyPart((BodyPart)htmlPart);
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom(mailFrom);
            if (!CollectionUtils.isEmpty(mailToList)) {
                msg.addRecipients(Message.RecipientType.TO, mailToList.toArray(new Address[0]));
            }
            if (!CollectionUtils.isEmpty(mailCcList)) {
                msg.addRecipients(Message.RecipientType.CC, mailCcList.toArray(new Address[0]));
            }
            if (!CollectionUtils.isEmpty(mailBccList)) {
                msg.addRecipients(Message.RecipientType.BCC, mailBccList.toArray(new Address[0]));
            }
            if (!CollectionUtils.isEmpty(replyToList)) {
                msg.setReplyTo(replyToList.toArray(new Address[0]));
            }
            msg.setSubject(title);
            msg.setContent((Multipart)multipart);
            Transport.send((Message)msg);
        }
        catch (AddressException e) {
            throw new PublishingException("Error sending email: " + (Object)((Object)e));
        }
        catch (MessagingException e) {
            throw new PublishingException("Error sending email: " + (Object)((Object)e));
        }
        catch (IOException e) {
            throw new PublishingException("Error sending email: " + e);
        }
    }

    protected Session createSession() {
        Properties props = this.createMailProperties();
        Authenticator authenticator = this.createAuthenticator(props, this.username, this.password);
        return Session.getDefaultInstance((Properties)props, (Authenticator)authenticator);
    }

    protected String embedImages(String root, Multipart multipart, String content) throws IOException, MessagingException {
        Pattern pattern = Pattern.compile("src=\"(" + this.getImagePattern() + ")\"");
        Matcher matcher = pattern.matcher(content);
        StringBuffer sb = new StringBuffer();
        HashMap<String, String> cidMapping = new HashMap<String, String>();
        while (matcher.find()) {
            String imagePath = matcher.group(1);
            String cid = (String)cidMapping.get(imagePath);
            if (cid == null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Attaching image: " + root + imagePath));
                }
                cid = UUID.randomUUID().toString();
                cidMapping.put(imagePath, cid);
                MimeBodyPart imagePart = new MimeBodyPart();
                File imageFile = new File(root + imagePath);
                if (imageFile.exists()) {
                    imagePart.attachFile(imageFile);
                    imagePart.setContentID("<" + cid + ">");
                    imagePart.setDisposition("inline");
                    multipart.addBodyPart((BodyPart)imagePart);
                } else if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)(root + imagePath + " does not exist."));
                }
            }
            matcher.appendReplacement(sb, "src=\"cid:" + cid + "\"");
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    protected String getHtmlContent(String path, String siteName) throws IOException, PublishingException {
        int status;
        String previewUrl = this.createPreviewUrl(path, siteName);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Accessing " + previewUrl));
        }
        HttpClient client = new HttpClient();
        GetMethod method = new GetMethod(previewUrl);
        if (this.getHeaders() != null) {
            for (Map.Entry<String, String> entry : this.getHeaders().entrySet()) {
                method.addRequestHeader(entry.getKey(), entry.getValue());
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug((Object)("Adding " + entry.getKey() + ", " + entry.getValue() + " to the request"));
            }
        }
        if ((status = client.executeMethod((HttpMethod)method)) == 200) {
            String htmlContent = method.getResponseBodyAsString();
            if (this.getContentReplacements() != null) {
                for (Map.Entry<String, String> entry : this.getContentReplacements().entrySet()) {
                    htmlContent = htmlContent.replaceAll(entry.getKey(), entry.getValue());
                }
            }
            this.validateContent(htmlContent);
            return htmlContent;
        }
        throw new PublishingException("STATUS:" + status + "\n" + method.getResponseBodyAsString());
    }

    protected String createPreviewUrl(String path, String siteName) {
        if (path.startsWith(PAGE_ROOT)) {
            String contentUrl = path;
            if (this.getUrlReplacements() != null) {
                for (Map.Entry<String, String> entry : this.getUrlReplacements().entrySet()) {
                    String replacement = this.getUrlReplacements().get(entry.getKey());
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("replacment: " + entry.getKey() + ", " + replacement));
                    }
                    contentUrl = contentUrl.replaceAll(entry.getKey(), replacement);
                }
            }
            return this.getPreviewUrl() + contentUrl + "?crafterSite=" + siteName;
        }
        return this.getPreviewUrl() + this.getComponentController() + "?path=" + path + "&crafterSite=" + siteName;
    }

    protected void validateContent(String htmlContent) throws PublishingException {
        if (this.getPositiveChecks() != null) {
            for (String positiveCheck : this.getPositiveChecks()) {
                if (htmlContent.contains(positiveCheck)) continue;
                throw new PublishingException("check failed due to no positive match: " + positiveCheck + "\n" + htmlContent);
            }
        }
        if (this.getNegativeChecks() != null) {
            for (String negativeCheck : this.getNegativeChecks()) {
                if (!htmlContent.contains(negativeCheck)) continue;
                throw new PublishingException("check failed due to a negative match: " + negativeCheck + "\n" + htmlContent);
            }
        }
    }

    protected Authenticator createAuthenticator(Properties props, final String username, final String password) {
        Authenticator authenticator = null;
        if (this.isAuthenticated()) {
            props.put(MAIL_SMTP_AUTH, "true");
            authenticator = new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(username, password);
                }
            };
        }
        return authenticator;
    }

    protected Properties createMailProperties() {
        Properties props = new Properties();
        props.put(MAIL_SMTP_HOST, this.getHost());
        props.put(MAIL_SMTP_PORT, this.getPort());
        if (PROTOCOL_SMTPS.equalsIgnoreCase(this.getProtocol())) {
            props.put(MAIL_SMTP_SSL, "true");
        } else if (PROTOCOL_TLS.equalsIgnoreCase(this.getProtocol())) {
            props.put(MAIL_SMTP_STARTTLS, "true");
        }
        return props;
    }

    protected boolean isMatchingPattern(String file) {
        if (this.getMatchPatterns() != null) {
            for (String matchPattern : this.getMatchPatterns()) {
                if (file.matches(matchPattern)) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)(file + " matched " + matchPattern));
                    }
                    return true;
                }
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug((Object)(file + " didn't match " + matchPattern));
            }
        }
        return false;
    }

    public String getCharEncoding() {
        return CHAR_ENCODING;
    }

    public String getPreviewUrl() {
        return this.previewUrl;
    }

    public void setPreviewUrl(String previewUrl) {
        this.previewUrl = previewUrl;
    }

    public List<String> getNegativeChecks() {
        return this.negativeChecks;
    }

    public void setNegativeChecks(List<String> negativeChecks) {
        this.negativeChecks = negativeChecks;
    }

    public List<String> getPositiveChecks() {
        return this.positiveChecks;
    }

    public void setPositiveChecks(List<String> positiveChecks) {
        this.positiveChecks = positiveChecks;
    }

    public String getMailToPath() {
        return this.mailToPath;
    }

    public void setMailToPath(String mailToPath) {
        this.mailToPath = mailToPath;
    }

    public String getMailCcPath() {
        return this.mailCcPath;
    }

    public void setMailCcPath(String mailCcPath) {
        this.mailCcPath = mailCcPath;
    }

    public String getMailBccPath() {
        return this.mailBccPath;
    }

    public void setMailBccPath(String mailBccPath) {
        this.mailBccPath = mailBccPath;
    }

    public String getMailFromPath() {
        return this.mailFromPath;
    }

    public void setMailFromPath(String mailFromPath) {
        this.mailFromPath = mailFromPath;
    }

    public String getReplyToPath() {
        return this.replyToPath;
    }

    public void setReplyToPath(String replyToPath) {
        this.replyToPath = replyToPath;
    }

    public String getTitlePath() {
        return this.titlePath;
    }

    public void setTitlePath(String titlePath) {
        this.titlePath = titlePath;
    }

    public String getTextContentPath() {
        return this.textContentPath;
    }

    public void setTextContentPath(String textContentPath) {
        this.textContentPath = textContentPath;
    }

    public String getDefaultMailFrom() {
        return this.defaultMailFrom;
    }

    public void setDefaultMailFrom(String defaultMailFrom) {
        this.defaultMailFrom = defaultMailFrom;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public String getImagePattern() {
        return this.imagePattern;
    }

    public void setImagePattern(String imagePattern) {
        this.imagePattern = imagePattern;
    }

    public String getComponentController() {
        return this.componentController;
    }

    public void setComponentController(String componentController) {
        this.componentController = componentController;
    }

    public Map<String, String> getUrlReplacements() {
        return this.urlReplacements;
    }

    public void setUrlReplacements(Map<String, String> urlReplacements) {
        this.urlReplacements = urlReplacements;
    }

    public Map<String, String> getContentReplacements() {
        return this.contentReplacements;
    }

    public void setContentReplacements(Map<String, String> contentReplacements) {
        this.contentReplacements = contentReplacements;
    }

    public List<String> getMatchPatterns() {
        return this.matchPatterns;
    }

    public void setMatchPatterns(List<String> matchPatterns) {
        this.matchPatterns = matchPatterns;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public void setAuthenticated(boolean authenticated) {
        this.authenticated = authenticated;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getSendEmailFlagPath() {
        return this.sendEmailFlagPath;
    }

    public void setSendEmailFlagPath(String sendEmailFlagPath) {
        this.sendEmailFlagPath = sendEmailFlagPath;
    }
}

