/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.cstudio.publishing;

import java.io.IOException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.cstudio.publishing.ReadablePropertyPlaceholderConfigurer;
import org.craftercms.cstudio.publishing.exception.PublishingException;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class StopServiceMain {
    private static Log LOGGER = LogFactory.getLog(StopServiceMain.class);
    private static String PROPERTIES_NAME = "cstudioShutdownProperties";
    private static String PROP_URL = "receiver.url";
    private static String PROP_SERVICE_PATH = "servlet.stopService.path";
    private static String PROP_PORT = "receiver.port";
    private static String PROP_PASSWORD = "receiver.password";

    public static void main(String[] args) throws Exception {
        FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext("classpath:spring/shutdown-context.xml");
        ReadablePropertyPlaceholderConfigurer properties = (ReadablePropertyPlaceholderConfigurer)((Object)context.getBean("cstudioShutdownProperties"));
        if (properties != null) {
            String url = StopServiceMain.getProperty(properties, PROP_URL);
            String path = StopServiceMain.getProperty(properties, PROP_SERVICE_PATH);
            String port = StopServiceMain.getProperty(properties, PROP_PORT);
            String password = URLEncoder.encode(StopServiceMain.getProperty(properties, PROP_PASSWORD), "UTF-8");
            String target = url + ":" + port + path;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Sending a stop request to " + target));
            }
            target = target + "?" + "password" + "=" + password;
            URL serviceUrl = new URL(target);
            HttpURLConnection connection = (HttpURLConnection)serviceUrl.openConnection();
            connection.setRequestMethod("GET");
            connection.setReadTimeout(10000);
            connection.connect();
            try {
                connection.getContent();
            }
            catch (ConnectException connectException) {}
        } else if (LOGGER.isErrorEnabled()) {
            LOGGER.error((Object)(PROPERTIES_NAME + " is not present in shutdown-context.xml"));
        }
        context.close();
    }

    private static String getProperty(ReadablePropertyPlaceholderConfigurer properties, String name) throws IOException, PublishingException {
        String value = properties.getProperty(name);
        if (value == null) {
            throw new PublishingException(name + " is not found in properties.");
        }
        return value;
    }
}

