/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.search.service.impl.v1;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.lang.UrlUtils;
import org.craftercms.core.service.Content;
import org.craftercms.search.exception.SearchException;
import org.craftercms.search.service.ResourceAwareSearchService;
import org.craftercms.search.service.impl.SolrQuery;
import org.craftercms.search.service.utils.ContentResource;
import org.craftercms.search.service.utils.RestClientUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

public class SolrRestClientSearchService
implements ResourceAwareSearchService<SolrQuery> {
    private static final Logger logger = LoggerFactory.getLogger(SolrRestClientSearchService.class);
    private static final String[] NON_ADDITIONAL_FIELD_NAMES = new String[]{"indexId", "site", "id", "document"};
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    public static final String DEFAULT_MULTI_VALUE_SEPARATOR = ",";
    protected String serverUrl;
    protected RestTemplate restTemplate;
    protected Charset charset = DEFAULT_CHARSET;
    protected boolean useUpdateDocumentRestApi;
    protected String multiValueSeparator = ",";

    public SolrRestClientSearchService() {
        this.restTemplate = RestClientUtils.createRestTemplate(this.charset);
    }

    @Required
    public void setServerUrl(String serverUrl) {
        this.serverUrl = StringUtils.stripEnd((String)serverUrl, (String)"/");
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public void setCharset(String charset) {
        this.charset = Charset.forName(charset);
    }

    public void setUseUpdateDocumentRestApi(boolean useUpdateDocumentRestApi) {
        this.useUpdateDocumentRestApi = useUpdateDocumentRestApi;
    }

    public void setMultiValueSeparator(String multiValueSeparator) {
        this.multiValueSeparator = multiValueSeparator;
    }

    public SolrQuery createQuery() {
        return new SolrQuery();
    }

    public SolrQuery createQuery(Map<String, String[]> params) {
        return new SolrQuery(params);
    }

    public Map<String, Object> search(SolrQuery query) throws SearchException {
        return this.search(null, query);
    }

    public Map<String, Object> search(String indexId, SolrQuery query) throws SearchException {
        String searchUrl = this.createBaseUrl("/search", indexId);
        searchUrl = UrlUtils.addQueryStringFragment((String)searchUrl, (String)query.toUrlQueryString());
        try {
            return (Map)this.restTemplate.getForObject(new URI(searchUrl), Map.class);
        }
        catch (URISyntaxException e) {
            throw new SearchException(indexId, "Invalid URI: " + searchUrl, (Throwable)e);
        }
        catch (HttpStatusCodeException e) {
            throw new SearchException(indexId, "Search for query " + query + " failed: [" + e.getStatusText() + "] " + e.getResponseBodyAsString());
        }
        catch (Exception e) {
            throw new SearchException(indexId, "Search for query " + query + " failed: " + e.getMessage(), (Throwable)e);
        }
    }

    public void update(String site, String id, String xml, boolean ignoreRootInFieldNames) throws SearchException {
        this.update(null, site, id, xml, ignoreRootInFieldNames);
    }

    public void update(String indexId, String site, String id, String xml, boolean ignoreRootInFieldNames) throws SearchException {
        String updateUrl = this.createBaseUrl("/update", indexId);
        updateUrl = RestClientUtils.addParam(updateUrl, "site", site);
        updateUrl = RestClientUtils.addParam(updateUrl, "id", id);
        updateUrl = RestClientUtils.addParam(updateUrl, "stripRoot", ignoreRootInFieldNames);
        try {
            MediaType contentType = new MediaType(MediaType.TEXT_XML, this.charset);
            RequestEntity request = RequestEntity.post((URI)new URI(updateUrl)).contentType(contentType).body((Object)xml);
            String result = (String)this.restTemplate.exchange(request, String.class).getBody();
            logger.debug("Result of {}: {}", (Object)updateUrl, (Object)result);
        }
        catch (URISyntaxException e) {
            throw new SearchException(indexId, "Invalid URI: " + updateUrl, (Throwable)e);
        }
        catch (HttpStatusCodeException e) {
            throw new SearchException(indexId, "Update for XML '" + id + "' failed: [" + e.getStatusText() + "] " + e.getResponseBodyAsString());
        }
        catch (Exception e) {
            throw new SearchException(indexId, "Update for XML '" + id + "' failed: " + e.getMessage(), (Throwable)e);
        }
    }

    public void delete(String site, String id) throws SearchException {
        this.delete(null, site, id);
    }

    public void delete(String indexId, String site, String id) throws SearchException {
        String deleteUrl = this.createBaseUrl("/delete", indexId);
        deleteUrl = RestClientUtils.addParam(deleteUrl, "site", site);
        deleteUrl = RestClientUtils.addParam(deleteUrl, "id", id);
        try {
            String result = (String)this.restTemplate.postForObject(new URI(deleteUrl), null, String.class);
            logger.debug("Result of {}: {}", (Object)deleteUrl, (Object)result);
        }
        catch (URISyntaxException e) {
            throw new SearchException(indexId, "Invalid URI: " + deleteUrl, (Throwable)e);
        }
        catch (HttpStatusCodeException e) {
            throw new SearchException(indexId, "Delete for XML '" + id + "' failed: [" + e.getStatusText() + "] " + e.getResponseBodyAsString());
        }
        catch (Exception e) {
            throw new SearchException(indexId, "Delete for XML '" + id + "' failed: " + e.getMessage(), (Throwable)e);
        }
    }

    public void commit() throws SearchException {
        this.commit(null);
    }

    public void commit(String indexId) throws SearchException {
        String commitUrl = this.createBaseUrl("/commit", indexId);
        try {
            String result = (String)this.restTemplate.postForObject(new URI(commitUrl), null, String.class);
            logger.debug("Result of {}: {}", (Object)commitUrl, (Object)result);
        }
        catch (URISyntaxException e) {
            throw new SearchException(indexId, "Invalid URI: " + commitUrl, (Throwable)e);
        }
        catch (HttpStatusCodeException e) {
            throw new SearchException(indexId, "Commit failed: [" + e.getStatusText() + "] " + e.getResponseBodyAsString());
        }
        catch (Exception e) {
            throw new SearchException(indexId, "Commit failed: " + e.getMessage(), (Throwable)e);
        }
    }

    public void updateContent(String site, String id, File file) throws SearchException {
        this.updateContent(null, site, id, file, null);
    }

    public void updateContent(String indexId, String site, String id, File file) throws SearchException {
        this.updateContent(indexId, site, id, file, null);
    }

    public void updateContent(String site, String id, File file, Map<String, List<String>> additionalFields) throws SearchException {
        this.updateContent(null, site, id, file, additionalFields);
    }

    public void updateContent(String indexId, String site, String id, File file, Map<String, List<String>> additionalFields) throws SearchException {
        this.updateContent(indexId, site, id, (Resource)new FileSystemResource(file), additionalFields);
    }

    public void updateContent(String site, String id, Content content) throws SearchException {
        this.updateContent(null, site, id, content, null);
    }

    public void updateContent(String indexId, String site, String id, Content content) throws SearchException {
        this.updateContent(indexId, site, id, content, null);
    }

    public void updateContent(String site, String id, Content content, Map<String, List<String>> additionalFields) throws SearchException {
        this.updateContent(null, site, id, content, additionalFields);
    }

    public void updateContent(String indexId, String site, String id, Content content, Map<String, List<String>> additionalFields) throws SearchException {
        String filename = FilenameUtils.getName((String)id);
        ContentResource resource = new ContentResource(content, filename);
        this.updateContent(indexId, site, id, (Resource)resource, additionalFields);
    }

    @Override
    public void updateContent(String indexId, String site, String id, Resource resource, Map<String, List<String>> additionalFields) throws SearchException {
        String updateUrl;
        LinkedMultiValueMap parts = new LinkedMultiValueMap();
        if (StringUtils.isNotEmpty((CharSequence)indexId)) {
            parts.set((Object)"indexId", (Object)indexId);
        }
        parts.set((Object)"site", (Object)site);
        parts.set((Object)"id", (Object)id);
        parts.set((Object)"document", (Object)resource);
        if (this.useUpdateDocumentRestApi) {
            RestClientUtils.addAdditionalFieldsToMultiPartRequest(additionalFields, (MultiValueMap<String, Object>)parts, NON_ADDITIONAL_FIELD_NAMES, this.multiValueSeparator);
            updateUrl = this.createBaseUrl("/update-document");
        } else {
            RestClientUtils.addAdditionalFieldsToMultiPartRequest(additionalFields, (MultiValueMap<String, Object>)parts, NON_ADDITIONAL_FIELD_NAMES, null);
            updateUrl = this.createBaseUrl("/update-file");
        }
        try {
            String result = (String)this.restTemplate.postForObject(new URI(updateUrl), (Object)parts, String.class);
            logger.debug("Result of {}: {}", (Object)updateUrl, (Object)result);
        }
        catch (URISyntaxException e) {
            throw new SearchException(indexId, "Invalid URI: " + updateUrl, (Throwable)e);
        }
        catch (HttpStatusCodeException e) {
            throw new SearchException(indexId, "Update for file '" + id + "' failed: [" + e.getStatusText() + "] " + e.getResponseBodyAsString());
        }
        catch (Exception e) {
            throw new SearchException(indexId, "Update for file '" + id + "' failed: " + e.getMessage(), (Throwable)e);
        }
    }

    protected String createBaseUrl(String serviceUrl) {
        return this.serverUrl + "/api/1/search" + serviceUrl;
    }

    protected String createBaseUrl(String serviceUrl, String indexId) {
        String url = this.createBaseUrl(serviceUrl);
        if (StringUtils.isNotEmpty((CharSequence)indexId)) {
            url = RestClientUtils.addParam(url, "indexId", indexId);
        }
        return url;
    }
}

