/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.search.service.utils;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.lang.UrlUtils;
import org.craftercms.search.exception.SearchException;
import org.craftercms.search.exception.SearchServerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

public class RestClientUtils {
    private static final Logger logger = LoggerFactory.getLogger(RestClientUtils.class);

    private RestClientUtils() {
    }

    public static String addParam(String url, String name, Object value) {
        try {
            return UrlUtils.addParam((String)url, (String)name, (String)value.toString(), (String)"UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void addAdditionalFieldsToMultiPartRequest(Map<String, List<String>> additionalFields, MultiValueMap<String, Object> parts, String[] nonAdditionalFields, String multiValueSeparator) {
        if (MapUtils.isNotEmpty(additionalFields)) {
            for (Map.Entry<String, List<String>> additionalField : additionalFields.entrySet()) {
                String fieldName = additionalField.getKey();
                if (ArrayUtils.contains((Object[])nonAdditionalFields, (Object)fieldName)) {
                    logger.info("Ignoring non-additional field {}", (Object)fieldName);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)multiValueSeparator)) {
                    parts.put((Object)fieldName, additionalField.getValue());
                    continue;
                }
                parts.add((Object)fieldName, (Object)StringUtils.join((Iterable)additionalField.getValue(), (String)multiValueSeparator));
            }
        }
    }

    public static RestTemplate createRestTemplate(Charset charset) {
        RestTemplate restTemplate = new RestTemplate();
        for (HttpMessageConverter converter : restTemplate.getMessageConverters()) {
            if (!(converter instanceof FormHttpMessageConverter)) continue;
            StringHttpMessageConverter stringHttpMessageConverter = new StringHttpMessageConverter(charset);
            stringHttpMessageConverter.setWriteAcceptCharset(false);
            ArrayList<Object> partConverters = new ArrayList<Object>();
            partConverters.add(new ByteArrayHttpMessageConverter());
            partConverters.add(stringHttpMessageConverter);
            partConverters.add(new ResourceHttpMessageConverter());
            ((FormHttpMessageConverter)converter).setPartConverters(partConverters);
        }
        return restTemplate;
    }

    public static SearchException getSearchException(String indexId, String message, HttpStatusCodeException e) {
        switch (e.getStatusCode()) {
            case SERVICE_UNAVAILABLE: {
                return new SearchServerException(message, (Throwable)e);
            }
        }
        return new SearchException(indexId, message, (Throwable)e);
    }
}

