/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.search.service.impl.v2;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.lang.UrlUtils;
import org.craftercms.commons.rest.Result;
import org.craftercms.search.exception.SearchException;
import org.craftercms.search.rest.v2.requests.CreateIndexRequest;
import org.craftercms.search.rest.v2.requests.DeleteIndexRequest;
import org.craftercms.search.service.AdminService;
import org.craftercms.search.service.utils.RestClientUtils;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

public class RestClientAdminService
implements AdminService {
    protected String serverUrl;
    protected RestTemplate restTemplate = new RestTemplate();

    public String getServerUrl() {
        return this.serverUrl;
    }

    @Required
    public void setServerUrl(String serverUrl) {
        this.serverUrl = StringUtils.stripEnd((String)serverUrl, (String)"/");
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public void createIndex(String id) throws SearchException {
        String createUrl = this.createBaseUrl("/index/create");
        CreateIndexRequest request = new CreateIndexRequest(id);
        try {
            this.restTemplate.postForObject(new URI(createUrl), (Object)request, Result.class);
        }
        catch (URISyntaxException e) {
            throw new SearchException(id, "Invalid URI: " + createUrl, (Throwable)e);
        }
        catch (HttpStatusCodeException e) {
            throw RestClientUtils.getSearchException(id, "Create index '" + id + "' failed: [" + e.getStatusText() + "] " + e.getResponseBodyAsString(), e);
        }
        catch (Exception e) {
            throw new SearchException(id, "Create index '" + id + "' failed: " + e.getMessage(), (Throwable)e);
        }
    }

    public Map<String, Object> getIndexInfo(String id) throws SearchException {
        String getUrl = this.createBaseUrl("/index/info/{id}");
        try {
            return (Map)this.restTemplate.getForObject(getUrl, Map.class, new Object[]{id});
        }
        catch (HttpStatusCodeException e) {
            throw RestClientUtils.getSearchException(id, "Get info for index '" + id + "' failed: [" + e.getStatusText() + "] " + e.getResponseBodyAsString(), e);
        }
        catch (Exception e) {
            throw new SearchException(id, "Get info for index '" + id + "' failed: " + e.getMessage(), (Throwable)e);
        }
    }

    public void deleteIndex(String id, AdminService.IndexDeleteMode mode) throws SearchException {
        String deleteUrl = this.createBaseUrl("/index/delete/{id}");
        DeleteIndexRequest request = new DeleteIndexRequest();
        request.setDeleteMode(mode);
        try {
            this.restTemplate.postForObject(deleteUrl, (Object)request, String.class, new Object[]{id});
        }
        catch (HttpStatusCodeException e) {
            throw RestClientUtils.getSearchException(id, "Delete index '" + id + "' failed: [" + e.getStatusText() + "] " + e.getResponseBodyAsString(), e);
        }
        catch (Exception e) {
            throw new SearchException(id, "Delete index '" + id + "' failed: " + e.getMessage(), (Throwable)e);
        }
    }

    protected String createBaseUrl(String serviceUrl) {
        return UrlUtils.concat((String)this.serverUrl, (String[])new String[]{"/api/2/admin", serviceUrl});
    }
}

