/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.security.spring.filter;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.craftercms.crafterprofile.user.UserProfile;
import org.craftercms.profile.api.ProfileClient;
import org.craftercms.profile.exceptions.AppAuthenticationFailedException;
import org.craftercms.profile.exceptions.UserAuthenticationFailedException;
import org.craftercms.profile.impl.domain.Profile;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.GrantedAuthorityImpl;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class CrafterProfileAuthenticationProvider
implements AuthenticationProvider {
    private ProfileClient profileRestClient;
    private String crafterProfileAppUsername;
    private String crafterProfileAppPassword;
    private String crafterProfileAppTenantName;
    private static final Logger log = Logger.getLogger(CrafterProfileAuthenticationProvider.class);

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String username = authentication.getName();
        String password = authentication.getCredentials().toString();
        try {
            String appToken = this.profileRestClient.getAppToken(this.crafterProfileAppUsername, this.crafterProfileAppPassword);
            String ticket = this.profileRestClient.getTicket(appToken, username, password, this.crafterProfileAppTenantName);
            Profile profile = this.profileRestClient.getProfileByUsernameWithAllAttributes(appToken, username, this.crafterProfileAppTenantName);
            if (profile == null) {
                log.error((Object)("Error getting profile for username=" + username + ", with appToken=" + appToken));
                throw new AuthenticationCredentialsNotFoundException("Error getting profile for username=" + username + ", with appToken=" + appToken);
            }
            UserProfile userProfile = this.getUserProfileObject();
            this.createUserProfile(profile, userProfile);
            userProfile.setTicket(ticket);
            return new UsernamePasswordAuthenticationToken((Object)userProfile, null, this.getGrantedAuthorityList(userProfile));
        }
        catch (AppAuthenticationFailedException e) {
            log.error((Object)("Error authenticating at app level=" + username));
            throw new BadCredentialsException("Error authenticating username=" + username, (Throwable)e);
        }
        catch (UserAuthenticationFailedException e) {
            log.error((Object)("Error authenticating username=" + username));
            throw new BadCredentialsException("Error authenticating username=" + username, (Throwable)e);
        }
    }

    protected UserProfile getUserProfileObject() {
        return new UserProfile();
    }

    protected void createUserProfile(Profile profile, UserProfile userProfile) {
        userProfile.setActive(profile.getActive());
        userProfile.setCreatedDate(profile.getCreated());
        userProfile.setModifiedDate(profile.getModified());
        userProfile.setId(profile.getId());
        userProfile.setUsername(profile.getUserName());
        userProfile.setTemporaryPassword(profile.getAttributes() == null ? false : Boolean.valueOf((String)profile.getAttributes().get("temporary-password")));
        userProfile.getRoles().addAll(profile.getRoles());
        userProfile.setTenantName(profile.getTenantName());
    }

    public boolean supports(Class<?> authentication) {
        return authentication.equals(UsernamePasswordAuthenticationToken.class);
    }

    public void setProfileRestClient(ProfileClient profileRestClient) {
        this.profileRestClient = profileRestClient;
    }

    @Value(value="${crafter.profile.app.username}")
    public void setCrafterProfileAppUsername(String crafterProfileAppUsername) {
        this.crafterProfileAppUsername = crafterProfileAppUsername;
    }

    @Value(value="${crafter.profile.app.password}")
    public void setCrafterProfileAppPassword(String crafterProfileAppPassword) {
        this.crafterProfileAppPassword = crafterProfileAppPassword;
    }

    @Value(value="${crafter.profile.app.tenant.name}")
    public void setCrafterProfileAppTenantName(String crafterProfileAppTenantName) {
        this.crafterProfileAppTenantName = crafterProfileAppTenantName;
    }

    public static List<GrantedAuthority> getGrantedAuthorities(List<String> roles) {
        if (roles == null || roles.size() == 0) {
            return null;
        }
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        for (String role : roles) {
            authorities.add((GrantedAuthority)new SimpleGrantedAuthority(role));
        }
        return authorities;
    }

    private List<GrantedAuthority> getGrantedAuthorityList(UserProfile userProfile) {
        ArrayList<GrantedAuthorityImpl> lga = null;
        if (userProfile.getRoles().size() > 0) {
            lga = new ArrayList<GrantedAuthorityImpl>();
            for (String r : userProfile.getRoles()) {
                GrantedAuthorityImpl ga = new GrantedAuthorityImpl(r);
                lga.add(ga);
            }
        }
        return lga;
    }
}

