/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.security.spring.handler;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.craftercms.security.spring.handler.CrafterProfileSuccessHandler;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;

public class CrafterGeneralProfileHandler
implements AuthenticationSuccessHandler {
    private static final Logger log = Logger.getLogger(CrafterProfileSuccessHandler.class);
    private AuthenticationSuccessHandler target;
    private String successUrl;

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication auth) {
        try {
            if (this.successUrl != null && !this.successUrl.equals("")) {
                response.sendRedirect(this.successUrl);
            } else {
                this.target.onAuthenticationSuccess(request, response, auth);
            }
        }
        catch (IOException e) {
            log.error((Object)("Error executing authentication success handler. " + e));
            try {
                response.sendError(500);
            }
            catch (IOException e1) {
                log.error((Object)("Error sending error 500. " + e));
            }
        }
        catch (ServletException e) {
            log.error((Object)("Error executing authentication success handler. " + (Object)((Object)e)));
            try {
                response.sendError(500);
            }
            catch (IOException e1) {
                log.error((Object)("Error sending error 500. " + (Object)((Object)e)));
            }
        }
    }

    public void setSuccessUrl(String successUrl) {
        this.successUrl = successUrl;
    }

    public void setTarget(AuthenticationSuccessHandler target) {
        this.target = target;
    }
}

