/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.security.services;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.craftercms.profile.api.ProfileClient;
import org.craftercms.profile.exceptions.AppAuthenticationFailedException;
import org.craftercms.profile.exceptions.UserAuthenticationFailedException;
import org.craftercms.profile.impl.domain.Profile;
import org.craftercms.user.ProfileUserDetails;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class CrafterAuthenticationUserDetailsService
implements AuthenticationUserDetailsService {
    private ProfileClient profileClient;
    private String crafterProfileAppUsername;
    private String crafterProfileAppPassword;
    private String crafterProfileAppTenantName;
    private static final Logger log = Logger.getLogger(CrafterAuthenticationUserDetailsService.class);

    public UserDetails loadUserDetails(Authentication token) throws UsernameNotFoundException {
        ProfileUserDetails userDetails = null;
        String username = token.getName();
        String password = token.getCredentials().toString();
        try {
            String appToken = this.profileClient.getAppToken(this.crafterProfileAppUsername, this.crafterProfileAppPassword);
            this.profileClient.getTicket(appToken, username, password, this.crafterProfileAppTenantName);
            Profile profile = this.profileClient.getProfileByUsernameWithAllAttributes(appToken, username, this.crafterProfileAppTenantName);
            userDetails = new ProfileUserDetails(profile, this.getAuthorities(profile));
        }
        catch (AppAuthenticationFailedException e) {
            log.error((Object)("Error authenticating at app level=" + username));
            throw new BadCredentialsException("Error authenticating username=" + username, (Throwable)e);
        }
        catch (UserAuthenticationFailedException e) {
            log.error((Object)("Error authenticating username=" + username));
            throw new BadCredentialsException("Error authenticating username=" + username, (Throwable)e);
        }
        return userDetails;
    }

    public void setProfileClient(ProfileClient profileClient) {
        this.profileClient = profileClient;
    }

    @Value(value="${crafter.profile.app.username}")
    public void setCrafterProfileAppUsername(String crafterProfileAppUsername) {
        this.crafterProfileAppUsername = crafterProfileAppUsername;
    }

    @Value(value="${crafter.profile.app.password}")
    public void setCrafterProfileAppPassword(String crafterProfileAppPassword) {
        this.crafterProfileAppPassword = crafterProfileAppPassword;
    }

    @Value(value="${crafter.profile.app.tenantName}")
    public void setCrafterProfileAppTenantName(String crafterProfileAppTenantName) {
        this.crafterProfileAppTenantName = crafterProfileAppTenantName;
    }

    private List<GrantedAuthority> getAuthorities(Profile p) {
        ArrayList<GrantedAuthority> lg = new ArrayList<GrantedAuthority>();
        for (String role : p.getRoles()) {
            lg.add((GrantedAuthority)new SimpleGrantedAuthority(role));
        }
        return lg;
    }
}

