/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.profile.social;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.crypto.TextEncryptor;
import org.craftercms.profile.api.Profile;
import org.craftercms.profile.api.exceptions.ProfileException;
import org.craftercms.profile.api.services.ProfileService;
import org.craftercms.profile.social.ProfileConnectionRepository;
import org.craftercms.profile.social.exceptions.SocialMediaIntegrationException;
import org.craftercms.profile.social.utils.TenantResolver;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.ConnectionFactoryLocator;
import org.springframework.social.connect.ConnectionRepository;
import org.springframework.social.connect.UsersConnectionRepository;

public class ProfileUsersConnectionRepository
implements UsersConnectionRepository {
    public static final String FIND_PROFILES_BY_PROVIDER_ID_AND_USER_ID_QUERY = "{attributes.connections.%s.providerUserId: {$in: [%s]}}";
    protected ProfileService profileService;
    protected TenantResolver tenantResolver;
    protected ConnectionFactoryLocator connectionFactoryLocator;
    protected TextEncryptor encryptor;

    @Required
    public void setProfileService(ProfileService profileService) {
        this.profileService = profileService;
    }

    @Required
    public void setTenantResolver(TenantResolver tenantResolver) {
        this.tenantResolver = tenantResolver;
    }

    @Required
    public void setConnectionFactoryLocator(ConnectionFactoryLocator connectionFactoryLocator) {
        this.connectionFactoryLocator = connectionFactoryLocator;
    }

    @Required
    public void setEncryptor(TextEncryptor encryptor) {
        this.encryptor = encryptor;
    }

    public List<String> findUserIdsWithConnection(Connection<?> connection) {
        String providerId = connection.getKey().getProviderId();
        String providerUserId = connection.getKey().getProviderUserId();
        String query = String.format(FIND_PROFILES_BY_PROVIDER_ID_AND_USER_ID_QUERY, providerId, providerUserId);
        List<Profile> profiles = this.findProfilesByQuery(query);
        if (CollectionUtils.isNotEmpty(profiles)) {
            ArrayList<String> ids = new ArrayList<String>(profiles.size());
            for (Profile profile : profiles) {
                ids.add(profile.getId().toString());
            }
            return ids;
        }
        return Collections.emptyList();
    }

    public Set<String> findUserIdsConnectedTo(String providerId, Set<String> providerUserIds) {
        String providerUserIdsStr = StringUtils.join(providerUserIds, (String)", ");
        String query = String.format(FIND_PROFILES_BY_PROVIDER_ID_AND_USER_ID_QUERY, providerId, providerUserIdsStr);
        List<Profile> profiles = this.findProfilesByQuery(query);
        if (CollectionUtils.isNotEmpty(profiles)) {
            LinkedHashSet<String> ids = new LinkedHashSet<String>(profiles.size());
            for (Profile profile : profiles) {
                ids.add(profile.getId().toString());
            }
            return ids;
        }
        return Collections.emptySet();
    }

    public ConnectionRepository createConnectionRepository(String userId) {
        Profile profile = this.findProfile(userId);
        if (profile != null) {
            return new ProfileConnectionRepository(this.connectionFactoryLocator, profile, this.profileService, this.encryptor);
        }
        return null;
    }

    public ConnectionRepository createConnectionRepository(Profile profile) {
        return new ProfileConnectionRepository(this.connectionFactoryLocator, profile, this.profileService, this.encryptor);
    }

    protected List<Profile> findProfilesByQuery(String query) {
        String tenant = this.tenantResolver.getCurrentTenant();
        try {
            return this.profileService.getProfilesByQuery(tenant, query, null, null, null, null, new String[]{"$none"});
        }
        catch (ProfileException e) {
            throw new SocialMediaIntegrationException("Unable to find profiles of tenant '" + tenant + "' by " + "query " + query, e);
        }
    }

    protected Profile findProfile(String profileId) {
        try {
            return this.profileService.getProfile(profileId, new String[0]);
        }
        catch (ProfileException e) {
            throw new SocialMediaIntegrationException("Unable to find profile '" + profileId + "'", e);
        }
    }
}

