/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.profile.social;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.craftercms.commons.crypto.CryptoException;
import org.craftercms.commons.crypto.TextEncryptor;
import org.craftercms.profile.api.Profile;
import org.craftercms.profile.api.exceptions.ProfileException;
import org.craftercms.profile.api.services.ProfileService;
import org.craftercms.profile.social.exceptions.SocialMediaIntegrationException;
import org.craftercms.profile.social.utils.ConnectionUtils;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.ConnectionData;
import org.springframework.social.connect.ConnectionFactory;
import org.springframework.social.connect.ConnectionFactoryLocator;
import org.springframework.social.connect.ConnectionKey;
import org.springframework.social.connect.ConnectionRepository;
import org.springframework.social.connect.NoSuchConnectionException;
import org.springframework.social.connect.NotConnectedException;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class ProfileConnectionRepository
implements ConnectionRepository {
    protected ConnectionFactoryLocator connectionFactoryLocator;
    protected Profile profile;
    protected String verificationUrl;
    protected ProfileService profileService;
    protected TextEncryptor encryptor;

    public ProfileConnectionRepository(ConnectionFactoryLocator connectionFactoryLocator, Profile profile, ProfileService profileService, TextEncryptor encryptor) {
        this.connectionFactoryLocator = connectionFactoryLocator;
        this.profile = profile;
        this.profileService = profileService;
        this.encryptor = encryptor;
    }

    public MultiValueMap<String, Connection<?>> findAllConnections() {
        LinkedMultiValueMap allConnections = new LinkedMultiValueMap();
        Map<String, List<Map<String, Object>>> allConnectionData = this.getConnectionsAttribute(this.profile);
        if (MapUtils.isNotEmpty(allConnectionData)) {
            for (Map.Entry<String, List<Map<String, Object>>> entry : allConnectionData.entrySet()) {
                String providerId = entry.getKey();
                for (Map<String, Object> connectionDataMap : entry.getValue()) {
                    ConnectionData connectionData = ConnectionUtils.mapToConnectionData(providerId, connectionDataMap, this.encryptor);
                    Connection<?> connection = this.createConnection(connectionData);
                    allConnections.add((Object)providerId, connection);
                }
            }
        }
        return allConnections;
    }

    public List<Connection<?>> findConnections(String providerId) {
        List<ConnectionData> connectionDataList;
        ArrayList connections = new ArrayList();
        try {
            connectionDataList = ConnectionUtils.getConnectionData(this.profile, providerId, this.encryptor);
        }
        catch (CryptoException e) {
            throw new SocialMediaIntegrationException("Decryption error", e);
        }
        if (CollectionUtils.isNotEmpty(connectionDataList)) {
            for (ConnectionData connectionData : connectionDataList) {
                connections.add(this.createConnection(connectionData));
            }
        }
        return connections;
    }

    public <A> List<Connection<A>> findConnections(Class<A> apiType) {
        List<Connection<A>> connections = this.findConnections(this.getProviderId(apiType));
        return connections;
    }

    public MultiValueMap<String, Connection<?>> findConnectionsToUsers(MultiValueMap<String, String> providerUserIds) {
        LinkedMultiValueMap connectionsForUserIds = new LinkedMultiValueMap();
        for (Map.Entry entry : providerUserIds.entrySet()) {
            List<ConnectionData> connectionDataList;
            String providerId = (String)entry.getKey();
            try {
                connectionDataList = ConnectionUtils.getConnectionData(this.profile, providerId, this.encryptor);
            }
            catch (CryptoException e) {
                throw new SocialMediaIntegrationException("Decryption error", e);
            }
            for (String providerUserId : (List)entry.getValue()) {
                Connection<?> connection = this.findConnection(connectionDataList, providerUserId);
                connectionsForUserIds.add((Object)providerId, connection);
            }
        }
        return connectionsForUserIds;
    }

    public Connection<?> getConnection(ConnectionKey connectionKey) {
        List<ConnectionData> connectionDataList;
        String providerId = connectionKey.getProviderId();
        try {
            connectionDataList = ConnectionUtils.getConnectionData(this.profile, providerId, this.encryptor);
        }
        catch (CryptoException e) {
            throw new SocialMediaIntegrationException("Decryption error", e);
        }
        Connection<?> connection = this.findConnection(connectionDataList, connectionKey.getProviderUserId());
        if (connection != null) {
            return connection;
        }
        throw new NoSuchConnectionException(connectionKey);
    }

    public <A> Connection<A> getConnection(Class<A> apiType, String providerUserId) {
        return this.getConnection(new ConnectionKey(this.getProviderId(apiType), providerUserId));
    }

    public <A> Connection<A> getPrimaryConnection(Class<A> apiType) {
        Connection<A> connection = this.findPrimaryConnection(apiType);
        if (connection != null) {
            return connection;
        }
        throw new NotConnectedException(this.getProviderId(apiType));
    }

    public <A> Connection<A> findPrimaryConnection(Class<A> apiType) {
        String providerId = this.getProviderId(apiType);
        List<Connection<?>> connections = this.findConnections(providerId);
        if (CollectionUtils.isNotEmpty(connections)) {
            return connections.get(0);
        }
        return null;
    }

    public void addConnection(Connection<?> connection) {
        ConnectionUtils.addConnectionData(this.profile, connection.createData(), this.encryptor);
        this.updateProfile();
    }

    public void updateConnection(Connection<?> connection) {
        this.addConnection(connection);
    }

    public void removeConnections(String providerId) {
        ConnectionUtils.removeConnectionData(this.profile, providerId);
        this.updateProfile();
    }

    public void removeConnection(ConnectionKey connectionKey) {
        String providerId = connectionKey.getProviderId();
        String providerUserId = connectionKey.getProviderUserId();
        ConnectionUtils.removeConnectionData(providerId, providerUserId, this.profile);
        this.updateProfile();
    }

    protected Connection<?> createConnection(ConnectionData data) {
        ConnectionFactory connectionFactory = this.connectionFactoryLocator.getConnectionFactory(data.getProviderId());
        return connectionFactory.createConnection(data);
    }

    protected Connection<?> findConnection(List<ConnectionData> connectionDataList, String providerUserId) {
        if (CollectionUtils.isNotEmpty(connectionDataList)) {
            for (ConnectionData connectionData : connectionDataList) {
                if (!connectionData.getProviderUserId().equals(providerUserId)) continue;
                return this.createConnection(connectionData);
            }
        }
        return null;
    }

    protected Map<String, List<Map<String, Object>>> getConnectionsAttribute(Profile profile) {
        return (Map)profile.getAttribute("connections");
    }

    protected <A> String getProviderId(Class<A> apiType) {
        return this.connectionFactoryLocator.getConnectionFactory(apiType).getProviderId();
    }

    protected void updateProfile() {
        try {
            this.profile = this.profileService.updateAttributes(this.profile.getId().toString(), this.profile.getAttributes(), new String[0]);
        }
        catch (ProfileException e) {
            throw new SocialMediaIntegrationException("Unable to update profile of user '" + this.profile.getId() + "'", e);
        }
    }
}

