/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.profile.services.impl;

import java.util.Collection;
import java.util.List;
import org.craftercms.commons.rest.RestClientUtils;
import org.craftercms.profile.api.AttributeDefinition;
import org.craftercms.profile.api.Tenant;
import org.craftercms.profile.api.exceptions.ProfileException;
import org.craftercms.profile.api.services.TenantService;
import org.craftercms.profile.services.impl.AbstractProfileRestClientBase;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.util.MultiValueMap;

public class TenantServiceRestClient
extends AbstractProfileRestClientBase
implements TenantService {
    public static final ParameterizedTypeReference<List<Tenant>> tenantListTypeRef = new ParameterizedTypeReference<List<Tenant>>(){};

    public Tenant createTenant(Tenant tenant) throws ProfileException {
        String url = this.getAbsoluteUrlWithAccessTokenIdParam("/api/1/tenant/create");
        return this.doPostForObject(url, tenant, Tenant.class, new Object[0]);
    }

    public Tenant getTenant(String name) throws ProfileException {
        String url = this.getAbsoluteUrlWithAccessTokenIdParam("/api/1/tenant/{name}");
        return this.doGetForObject(url, Tenant.class, name);
    }

    public Tenant updateTenant(Tenant tenant) throws ProfileException {
        String url = this.getAbsoluteUrlWithAccessTokenIdParam("/api/1/tenant/update");
        return this.doPostForObject(url, tenant, Tenant.class, new Object[0]);
    }

    public void deleteTenant(String name) throws ProfileException {
        String url = this.getAbsoluteUrl("/api/1/tenant/{name}/delete");
        this.doPostForLocation(url, this.createBaseParams(), name);
    }

    public long getTenantCount() throws ProfileException {
        String url = this.getAbsoluteUrlWithAccessTokenIdParam("/api/1/tenant/count");
        return this.doGetForObject(url, Long.class, new Object[0]);
    }

    public List<Tenant> getAllTenants() throws ProfileException {
        String url = this.getAbsoluteUrlWithAccessTokenIdParam("/api/1/tenant/all");
        return this.doGetForObject(url, tenantListTypeRef, new Object[0]);
    }

    public Tenant verifyNewProfiles(String tenantName, boolean verify) throws ProfileException {
        MultiValueMap<String, String> params = this.createBaseParams();
        RestClientUtils.addValue((String)"verify", (Object)verify, params);
        String url = this.getAbsoluteUrl("/api/1/tenant/{name}/verify_new_profiles");
        return this.doPostForObject(url, params, Tenant.class, tenantName);
    }

    public Tenant addRoles(String tenantName, Collection<String> roles) throws ProfileException {
        MultiValueMap<String, String> params = this.createBaseParams();
        RestClientUtils.addValues((String)"role", roles, params);
        String url = this.getAbsoluteUrl("/api/1/tenant/{name}/roles/add");
        return this.doPostForObject(url, params, Tenant.class, tenantName);
    }

    public Tenant removeRoles(String tenantName, Collection<String> roles) throws ProfileException {
        MultiValueMap<String, String> params = this.createBaseParams();
        RestClientUtils.addValues((String)"role", roles, params);
        String url = this.getAbsoluteUrl("/api/1/tenant/{id}/roles/remove");
        return this.doPostForObject(url, params, Tenant.class, tenantName);
    }

    public Tenant addAttributeDefinitions(String tenantName, Collection<AttributeDefinition> attributeDefinitions) throws ProfileException {
        String url = this.getAbsoluteUrlWithAccessTokenIdParam("/api/1/tenant/{name}/attribute_definitions/add");
        return this.doPostForObject(url, attributeDefinitions, Tenant.class, tenantName);
    }

    public Tenant updateAttributeDefinitions(String tenantName, Collection<AttributeDefinition> attributeDefinitions) throws ProfileException {
        String url = this.getAbsoluteUrlWithAccessTokenIdParam("/api/1/tenant/{name}/attribute_definitions/update");
        return this.doPostForObject(url, attributeDefinitions, Tenant.class, tenantName);
    }

    public Tenant removeAttributeDefinitions(String tenantName, Collection<String> attributeNames) throws ProfileException {
        MultiValueMap<String, String> params = this.createBaseParams();
        RestClientUtils.addValues((String)"attributeName", attributeNames, params);
        String url = this.getAbsoluteUrl("/api/1/tenant/{name}/attribute_definitions/remove");
        return this.doPostForObject(url, params, Tenant.class, tenantName);
    }
}

