/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.profile.services.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.MapUtils;
import org.craftercms.commons.rest.RestClientUtils;
import org.craftercms.profile.api.Profile;
import org.craftercms.profile.api.SortOrder;
import org.craftercms.profile.api.VerificationToken;
import org.craftercms.profile.api.exceptions.I10nProfileException;
import org.craftercms.profile.api.exceptions.ProfileException;
import org.craftercms.profile.api.services.ProfileService;
import org.craftercms.profile.services.impl.AbstractProfileRestClientBase;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.util.MultiValueMap;

public class ProfileServiceRestClient
extends AbstractProfileRestClientBase
implements ProfileService {
    public static final ParameterizedTypeReference<List<Profile>> profileListTypeRef = new ParameterizedTypeReference<List<Profile>>(){};
    public static final String ERROR_KEY_ATTRIBUTES_SERIALIZATION_ERROR = "profile.client.attributes.serializationError";
    public static final String ERROR_KEY_INVALID_URI_ERROR = "profile.client.invalidUri";
    private ObjectMapper objectMapper;

    @Required
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public Profile createProfile(String tenantName, String username, String password, String email, boolean enabled, Set<String> roles, Map<String, Object> attributes, String verificationUrl) throws ProfileException {
        MultiValueMap<String, String> params = this.createBaseParams();
        RestClientUtils.addValue((String)"tenantName", (Object)tenantName, params);
        RestClientUtils.addValue((String)"username", (Object)username, params);
        RestClientUtils.addValue((String)"password", (Object)password, params);
        RestClientUtils.addValue((String)"email", (Object)email, params);
        RestClientUtils.addValue((String)"enabled", (Object)enabled, params);
        RestClientUtils.addValues((String)"role", roles, params);
        if (MapUtils.isNotEmpty(attributes)) {
            RestClientUtils.addValue((String)"attributes", (Object)this.serializeAttributes(attributes), params);
        }
        RestClientUtils.addValue((String)"verificationUrl", (Object)verificationUrl, params);
        String url = this.getAbsoluteUrl("/api/1/profile/create");
        return this.doPostForObject(url, params, Profile.class, new Object[0]);
    }

    public Profile updateProfile(String profileId, String username, String password, String email, Boolean enabled, Set<String> roles, Map<String, Object> attributes, String ... attributesToReturn) throws ProfileException {
        MultiValueMap<String, String> params = this.createBaseParams();
        RestClientUtils.addValue((String)"username", (Object)username, params);
        RestClientUtils.addValue((String)"password", (Object)password, params);
        RestClientUtils.addValue((String)"email", (Object)email, params);
        RestClientUtils.addValue((String)"enabled", (Object)enabled, params);
        if (roles != null && roles.isEmpty()) {
            RestClientUtils.addValue((String)"role", (Object)"", params);
        } else {
            RestClientUtils.addValues((String)"role", roles, params);
        }
        if (MapUtils.isNotEmpty(attributes)) {
            RestClientUtils.addValue((String)"attributes", (Object)this.serializeAttributes(attributes), params);
        }
        RestClientUtils.addValues((String)"attributeToReturn", (String[])attributesToReturn, params);
        String url = this.getAbsoluteUrl("/api/1/profile/{id}/update");
        return this.doPostForObject(url, params, Profile.class, profileId);
    }

    public Profile verifyProfile(String verificationTokenId, String ... attributesToReturn) throws ProfileException {
        MultiValueMap<String, String> params = this.createBaseParams();
        RestClientUtils.addValue((String)"verificationTokenId", (Object)verificationTokenId, params);
        RestClientUtils.addValues((String)"attributeToReturn", (String[])attributesToReturn, params);
        String url = this.getAbsoluteUrl("/api/1/profile/verify");
        return this.doPostForObject(url, params, Profile.class, new Object[0]);
    }

    public Profile enableProfile(String profileId, String ... attributesToReturn) throws ProfileException {
        MultiValueMap<String, String> params = this.createBaseParams();
        RestClientUtils.addValues((String)"attributeToReturn", (String[])attributesToReturn, params);
        String url = this.getAbsoluteUrl("/api/1/profile/{id}/enable");
        return this.doPostForObject(url, params, Profile.class, profileId);
    }

    public Profile disableProfile(String profileId, String ... attributesToReturn) throws ProfileException {
        MultiValueMap<String, String> params = this.createBaseParams();
        RestClientUtils.addValues((String)"attributeToReturn", (String[])attributesToReturn, params);
        String url = this.getAbsoluteUrl("/api/1/profile/{id}/disable");
        return this.doPostForObject(url, params, Profile.class, profileId);
    }

    public Profile addRoles(String profileId, Collection<String> roles, String ... attributesToReturn) throws ProfileException {
        MultiValueMap<String, String> params = this.createBaseParams();
        RestClientUtils.addValues((String)"role", roles, params);
        RestClientUtils.addValues((String)"attributeToReturn", (String[])attributesToReturn, params);
        String url = this.getAbsoluteUrl("/api/1/profile/{id}/roles/add");
        return this.doPostForObject(url, params, Profile.class, profileId);
    }

    public Profile removeRoles(String profileId, Collection<String> roles, String ... attributesToReturn) throws ProfileException {
        MultiValueMap<String, String> params = this.createBaseParams();
        RestClientUtils.addValues((String)"role", roles, params);
        RestClientUtils.addValues((String)"attributeToReturn", (String[])attributesToReturn, params);
        String url = this.getAbsoluteUrl("/api/1/profile/{id}/roles/remove");
        return this.doPostForObject(url, params, Profile.class, profileId);
    }

    public Map<String, Object> getAttributes(String profileId, String ... attributesToReturn) throws ProfileException {
        MultiValueMap<String, String> params = this.createBaseParams();
        RestClientUtils.addValues((String)"attributeToReturn", (String[])attributesToReturn, params);
        String url = this.getAbsoluteUrl("/api/1/profile/{id}/attributes");
        url = RestClientUtils.addQueryParams((String)url, params, (boolean)false);
        return this.doGetForObject(url, Map.class, profileId);
    }

    public Profile updateAttributes(String profileId, Map<String, Object> attributes, String ... attributesToReturn) throws ProfileException {
        MultiValueMap<String, String> params = this.createBaseParams();
        RestClientUtils.addValues((String)"attributeToReturn", (String[])attributesToReturn, params);
        String url = this.getAbsoluteUrl("/api/1/profile/{id}/attributes/update");
        url = RestClientUtils.addQueryParams((String)url, params, (boolean)false);
        return this.doPostForObject(url, attributes, Profile.class, profileId);
    }

    public Profile removeAttributes(String profileId, Collection<String> attributeNames, String ... attributesToReturn) throws ProfileException {
        MultiValueMap<String, String> params = this.createBaseParams();
        RestClientUtils.addValues((String)"attributeName", attributeNames, params);
        RestClientUtils.addValues((String)"attributeToReturn", (String[])attributesToReturn, params);
        String url = this.getAbsoluteUrl("/api/1/profile/{id}/attributes/remove");
        return this.doPostForObject(url, params, Profile.class, profileId);
    }

    public void deleteProfile(String profileId) throws ProfileException {
        String url = this.getAbsoluteUrl("/api/1/profile/{id}/delete");
        this.doPostForLocation(url, this.createBaseParams(), profileId);
    }

    public Profile getProfileByQuery(String tenantName, String query, String ... attributesToReturn) throws ProfileException {
        MultiValueMap<String, String> params = this.createBaseParams();
        RestClientUtils.addValue((String)"tenantName", (Object)tenantName, params);
        RestClientUtils.addValue((String)"query", (Object)query, params);
        RestClientUtils.addValues((String)"attributeToReturn", (String[])attributesToReturn, params);
        String url = this.getAbsoluteUrl("/api/1/profile/one_by_query");
        url = RestClientUtils.addQueryParams((String)url, params, (boolean)true);
        try {
            return this.doGetForObject(new URI(url), Profile.class);
        }
        catch (URISyntaxException e) {
            throw new I10nProfileException(ERROR_KEY_INVALID_URI_ERROR, new Object[]{url});
        }
    }

    public Profile getProfile(String profileId, String ... attributesToReturn) throws ProfileException {
        MultiValueMap<String, String> params = this.createBaseParams();
        RestClientUtils.addValues((String)"attributeToReturn", (String[])attributesToReturn, params);
        String url = this.getAbsoluteUrl("/api/1/profile/{id}");
        url = RestClientUtils.addQueryParams((String)url, params, (boolean)false);
        return this.doGetForObject(url, Profile.class, profileId);
    }

    public Profile getProfileByUsername(String tenantName, String username, String ... attributesToReturn) throws ProfileException {
        MultiValueMap<String, String> params = this.createBaseParams();
        RestClientUtils.addValue((String)"tenantName", (Object)tenantName, params);
        RestClientUtils.addValue((String)"username", (Object)username, params);
        RestClientUtils.addValues((String)"attributeToReturn", (String[])attributesToReturn, params);
        String url = this.getAbsoluteUrl("/api/1/profile/by_username");
        url = RestClientUtils.addQueryParams((String)url, params, (boolean)false);
        return this.doGetForObject(url, Profile.class, new Object[0]);
    }

    public Profile getProfileByTicket(String ticketId, String ... attributesToReturn) throws ProfileException {
        MultiValueMap<String, String> params = this.createBaseParams();
        RestClientUtils.addValue((String)"ticketId", (Object)ticketId, params);
        RestClientUtils.addValues((String)"attributeToReturn", (String[])attributesToReturn, params);
        String url = this.getAbsoluteUrl("/api/1/profile/by_ticket");
        url = RestClientUtils.addQueryParams((String)url, params, (boolean)false);
        return this.doGetForObject(url, Profile.class, new Object[0]);
    }

    public long getProfileCount(String tenantName) throws ProfileException {
        MultiValueMap<String, String> params = this.createBaseParams();
        RestClientUtils.addValue((String)"tenantName", (Object)tenantName, params);
        String url = this.getAbsoluteUrl("/api/1/profile/count");
        url = RestClientUtils.addQueryParams((String)url, params, (boolean)false);
        return this.doGetForObject(url, Long.class, new Object[0]);
    }

    public long getProfileCountByQuery(String tenantName, String query) throws ProfileException {
        MultiValueMap<String, String> params = this.createBaseParams();
        RestClientUtils.addValue((String)"tenantName", (Object)tenantName, params);
        RestClientUtils.addValue((String)"query", (Object)query, params);
        String url = this.getAbsoluteUrl("/api/1/profile/count_by_query");
        url = RestClientUtils.addQueryParams((String)url, params, (boolean)true);
        try {
            return this.doGetForObject(new URI(url), Long.class);
        }
        catch (URISyntaxException e) {
            throw new I10nProfileException(ERROR_KEY_INVALID_URI_ERROR, new Object[]{url});
        }
    }

    public List<Profile> getProfilesByQuery(String tenantName, String query, String sortBy, SortOrder sortOrder, Integer start, Integer count, String ... attributesToReturn) throws ProfileException {
        MultiValueMap<String, String> params = this.createBaseParams();
        RestClientUtils.addValue((String)"tenantName", (Object)tenantName, params);
        RestClientUtils.addValue((String)"query", (Object)query, params);
        RestClientUtils.addValue((String)"sortBy", (Object)sortBy, params);
        RestClientUtils.addValue((String)"sortOrder", (Object)sortOrder, params);
        RestClientUtils.addValue((String)"start", (Object)start, params);
        RestClientUtils.addValue((String)"count", (Object)count, params);
        RestClientUtils.addValues((String)"attributeToReturn", (String[])attributesToReturn, params);
        String url = this.getAbsoluteUrl("/api/1/profile/by_query");
        url = RestClientUtils.addQueryParams((String)url, params, (boolean)true);
        try {
            return this.doGetForObject(new URI(url), profileListTypeRef);
        }
        catch (URISyntaxException e) {
            throw new I10nProfileException(ERROR_KEY_INVALID_URI_ERROR, new Object[]{url});
        }
    }

    public List<Profile> getProfilesByIds(List<String> profileIds, String sortBy, SortOrder sortOrder, String ... attributesToReturn) throws ProfileException {
        MultiValueMap<String, String> params = this.createBaseParams();
        RestClientUtils.addValues((String)"id", profileIds, params);
        RestClientUtils.addValue((String)"sortBy", (Object)sortBy, params);
        RestClientUtils.addValue((String)"sortOrder", (Object)sortOrder, params);
        RestClientUtils.addValues((String)"attributeToReturn", (String[])attributesToReturn, params);
        String url = this.getAbsoluteUrl("/api/1/profile/by_ids");
        url = RestClientUtils.addQueryParams((String)url, params, (boolean)false);
        return this.doGetForObject(url, profileListTypeRef, new Object[0]);
    }

    public List<Profile> getProfileRange(String tenantName, String sortBy, SortOrder sortOrder, Integer start, Integer count, String ... attributesToReturn) throws ProfileException {
        MultiValueMap<String, String> params = this.createBaseParams();
        RestClientUtils.addValue((String)"tenantName", (Object)tenantName, params);
        RestClientUtils.addValue((String)"sortBy", (Object)sortBy, params);
        RestClientUtils.addValue((String)"sortOrder", (Object)sortOrder, params);
        RestClientUtils.addValue((String)"start", (Object)start, params);
        RestClientUtils.addValue((String)"count", (Object)count, params);
        RestClientUtils.addValues((String)"attributeToReturn", (String[])attributesToReturn, params);
        String url = this.getAbsoluteUrl("/api/1/profile/range");
        url = RestClientUtils.addQueryParams((String)url, params, (boolean)false);
        return this.doGetForObject(url, profileListTypeRef, new Object[0]);
    }

    public List<Profile> getProfilesByRole(String tenantName, String role, String sortBy, SortOrder sortOrder, String ... attributesToReturn) throws ProfileException {
        MultiValueMap<String, String> params = this.createBaseParams();
        RestClientUtils.addValue((String)"tenantName", (Object)tenantName, params);
        RestClientUtils.addValue((String)"role", (Object)role, params);
        RestClientUtils.addValue((String)"sortBy", (Object)sortBy, params);
        RestClientUtils.addValue((String)"sortOrder", (Object)sortOrder, params);
        RestClientUtils.addValues((String)"attributeToReturn", (String[])attributesToReturn, params);
        String url = this.getAbsoluteUrl("/api/1/profile/by_role");
        url = RestClientUtils.addQueryParams((String)url, params, (boolean)false);
        return this.doGetForObject(url, profileListTypeRef, new Object[0]);
    }

    public List<Profile> getProfilesByExistingAttribute(String tenantName, String attributeName, String sortBy, SortOrder sortOrder, String ... attributesToReturn) throws ProfileException {
        MultiValueMap<String, String> params = this.createBaseParams();
        RestClientUtils.addValue((String)"tenantName", (Object)tenantName, params);
        RestClientUtils.addValue((String)"attributeName", (Object)attributeName, params);
        RestClientUtils.addValue((String)"sortBy", (Object)sortBy, params);
        RestClientUtils.addValue((String)"sortOrder", (Object)sortOrder, params);
        RestClientUtils.addValues((String)"attributeToReturn", (String[])attributesToReturn, params);
        String url = this.getAbsoluteUrl("/api/1/profile/by_existing_attribute");
        url = RestClientUtils.addQueryParams((String)url, params, (boolean)false);
        return this.doGetForObject(url, profileListTypeRef, new Object[0]);
    }

    public List<Profile> getProfilesByAttributeValue(String tenantName, String attributeName, String attributeValue, String sortBy, SortOrder sortOrder, String ... attributesToReturn) throws ProfileException {
        MultiValueMap<String, String> params = this.createBaseParams();
        RestClientUtils.addValue((String)"tenantName", (Object)tenantName, params);
        RestClientUtils.addValue((String)"attributeName", (Object)attributeName, params);
        RestClientUtils.addValue((String)"attributeValue", (Object)attributeValue, params);
        RestClientUtils.addValue((String)"sortBy", (Object)sortBy, params);
        RestClientUtils.addValue((String)"sortOrder", (Object)sortOrder, params);
        RestClientUtils.addValues((String)"attributeToReturn", (String[])attributesToReturn, params);
        String url = this.getAbsoluteUrl("/api/1/profile/by_attribute_value");
        url = RestClientUtils.addQueryParams((String)url, params, (boolean)false);
        return this.doGetForObject(url, profileListTypeRef, new Object[0]);
    }

    public Profile resetPassword(String profileId, String resetPasswordUrl, String ... attributesToReturn) throws ProfileException {
        MultiValueMap<String, String> params = this.createBaseParams();
        RestClientUtils.addValue((String)"resetPasswordUrl", (Object)resetPasswordUrl, params);
        RestClientUtils.addValues((String)"attributeToReturn", (String[])attributesToReturn, params);
        String url = this.getAbsoluteUrl("/api/1/profile/{id}/reset_password");
        return this.doPostForObject(url, params, Profile.class, profileId);
    }

    public Profile changePassword(String resetTokenId, String newPassword, String ... attributesToReturn) throws ProfileException {
        MultiValueMap<String, String> params = this.createBaseParams();
        RestClientUtils.addValue((String)"resetTokenId", (Object)resetTokenId, params);
        RestClientUtils.addValue((String)"newPassword", (Object)newPassword, params);
        RestClientUtils.addValues((String)"attributeToReturn", (String[])attributesToReturn, params);
        String url = this.getAbsoluteUrl("/api/1/profile/change_password");
        return this.doPostForObject(url, params, Profile.class, new Object[0]);
    }

    public VerificationToken createVerificationToken(String profileId) throws ProfileException {
        String url = this.getAbsoluteUrl("/api/1/profile/{id}/verification/create_token");
        return this.doPostForObject(url, this.createBaseParams(), VerificationToken.class, profileId);
    }

    public void deleteVerificationToken(String tokenId) throws ProfileException {
        MultiValueMap<String, String> params = this.createBaseParams();
        RestClientUtils.addValue((String)"tokenId", (Object)tokenId, params);
        String url = this.getAbsoluteUrl("/api/1/profile/verification/delete_token");
        this.doPostForLocation(url, params, new Object[0]);
    }

    protected String serializeAttributes(Map<String, Object> attributes) throws ProfileException {
        try {
            return this.objectMapper.writeValueAsString(attributes);
        }
        catch (Exception e) {
            throw new I10nProfileException(ERROR_KEY_ATTRIBUTES_SERIALIZATION_ERROR, (Throwable)e, new Object[0]);
        }
    }
}

